package com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/14 9:48
 * @description: 结案核销发票管理主表Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInvoiceManageDto", description = "结案核销发票管理主表Dto")
public class AuditInvoiceManageDto extends TenantFlagOpDto {

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("销售组织编码")
    private String saleOrgCode;

    @ApiModelProperty("销售组织名称")
    private String saleOrgName;

    @ApiModelProperty(name = "组织编码", notes = "组织编码")
    private String orgCode;

    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    private String orgName;

    @ApiModelProperty("区域编码")
    private String areaCode;

    @ApiModelProperty("区域名称")
    private String areaName;

    @ApiModelProperty("附件")
    private List<AuditInvoiceManageFileDto> invoiceFileUrl;

    @ApiModelProperty("发票编码(系统自动生成)")
    private String invoiceCrmCode;

    @ApiModelProperty("是否实质性发票")
    private String isMaterialInvoice;

    @ApiModelProperty("发票类型")
    private String invoiceType;

    @ApiModelProperty("发票代码")
    private String invoiceCode;

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    private String invoiceNo;

    @ApiModelProperty("开票日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date billingDate;


    @ApiModelProperty("开票日期开始")
    private String billingDateBegin;

    @ApiModelProperty("开票日期结束")
    private String billingDateEnd;

    @ApiModelProperty("校验码(只允许填写数字和字母)")
    private String checkCode;

    @ApiModelProperty("购买方名称")
    private String purchaser;

    @ApiModelProperty("购买方税号")
    private String pNo;

    @ApiModelProperty("购买方开户行及账号")
    private String pBankAndAccount;

    @ApiModelProperty("购买方地址电话")
    private String pAddressAndPhone;

    @ApiModelProperty("销售方名称")
    private String seller;

    @ApiModelProperty("销售方税号")
    private String sNo;

    @ApiModelProperty("销售方开户行及账号")
    private String sBankAndAccount;

    @ApiModelProperty("销售方地址电话")
    private String sAddressAndPhone;

    @ApiModelProperty("税价合计(含税金额)")
    private BigDecimal priceAndTax;

    @ApiModelProperty("不含税金额")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal taxAmount;

    @ApiModelProperty("已使用金额")
    private BigDecimal useAmount;

    @ApiModelProperty("可用余额")
    private BigDecimal ableAmount;

    @ApiModelProperty("文件唯一识别号")
    private String fileCode;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("原始文件名")
    private String originalFileName;

    @ApiModelProperty("本次使用金额")
    private BigDecimal thisUseAmount;

    @ApiModelProperty("是否手动录入")
    private String isManual;

    @ApiModelProperty("发票行明细")
    private List<AuditInvoiceManageItemDto> lineList;

    @ApiModelProperty("websocketId")
    private String websocketId;

    @ApiModelProperty("是否使用")
    private String isUse;

    @ApiModelProperty("核销编码")
    private String auditCode;

    @ApiModelProperty("创建时间前端用")
    private String createTimeStr;
}
