package com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.FileDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/11/16 17:48
 * @description: 结案核销发票管理文件Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInvoiceManageFileDto", description = "结案核销发票管理文件Dto")
public class AuditInvoiceManageFileDto extends FileDto {

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    private String invoiceNo;

    @ApiModelProperty("发票编码(系统自动生成)")
    private String invoiceCrmCode;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("文件大小")
    private Integer fileSize;

    @ApiModelProperty("有效期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveDate;

    @ApiModelProperty("相对路径")
    private String relativeLocal;

    @ApiModelProperty("uid")
    private String uid;

    @ApiModelProperty("文件后缀")
    private String prefix;

    @ApiModelProperty("提交人")
    private String commitUser;
}
