package com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2023/3/10 13:45
 * @description: 结案核销发票管理-行明细Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInvoiceManageItemDto", description = "结案核销发票管理-行明细Dto")
public class AuditInvoiceManageItemDto extends TenantFlagOpDto {

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    private String invoiceNo;

    @ApiModelProperty("发票编码(系统自动生成)")
    private String invoiceCrmCode;

    @ApiModelProperty("行号")
    private String itemNo;

    @ApiModelProperty("商品编码")
    private String goodsCode;

    @ApiModelProperty("货物或应税劳务名称")
    private String goodsTaxableName;

    @ApiModelProperty("规格型号/航班号/车次")
    private String specModel;

    @ApiModelProperty("单位/舱位/座席")
    private String unitSeat;

    @ApiModelProperty("购买数量 0 无效")
    private BigDecimal purchaseQuantity;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty("金额")
    private BigDecimal amount;

    @ApiModelProperty("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("税额")
    private BigDecimal tax;

    @ApiModelProperty("车牌号")
    private String carLicense;

    @ApiModelProperty("通行日期始出发日期时间字符串")
    private String startDate;

    @ApiModelProperty("通行日期止出发日期时间字符串")
    private String endDate;

    @ApiModelProperty("城市名称用,隔开")
    private String cityName;

    @ApiModelProperty("城市编号用,隔开")
    private String cityCode;

    @ApiModelProperty("出口站")
    private String exitStation;

    @ApiModelProperty("入口站")
    private String entranceStation;
}
