package com.biz.crm.tpm.business.audit.invoice.manage.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/1/7 10:02
 * @description: 发票识别类型
 */
public enum InvoiceCheckTypeEnum {

    WAIT_IDENTIFY("wait_identify", "待识别", ""),
    IDENTIFYING("identifying", "识别中", ""),
    FAIL_IDENTIFY("fail_identify", "识别失败", ""),
    VERIFY_TRUTH("verify_truth", "识别成功，验真中", ""),
    SUCCESS_VERIFY_TRUTH("success_verify_truth", "验真成功", ""),
    FAIL_VERIFY_TRUTH("fail_verify_truth", "验真失败", ""),
    SUCCESS_SAVE("success_save", "保存成功", ""),
    ALREADY_EXISTS("already_exists", "系统已存在此发票", ""),
    DUPLICATE_INVOICE_UPLOAD("duplicate_invoice_upload", "发票重复上传", ""),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;
    private String format;

    InvoiceCheckTypeEnum(String code, String des, String format) {
        this.code = code;
        this.des = des;
        this.format = format;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public String getFormat() {
        return this.format;
    }

    public static InvoiceCheckTypeEnum codeToEnum(String code) {
        InvoiceCheckTypeEnum invoiceTypeEnum = null;
        InvoiceCheckTypeEnum[] var2 = values();

        for (InvoiceCheckTypeEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                invoiceTypeEnum = typeEnum;
            }
        }
        return invoiceTypeEnum;
    }

    /**
     * 转换为对应map
     *
     * @return java.util.Map<java.lang.String, java.lang.String>
     **/
    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (InvoiceCheckTypeEnum t : InvoiceCheckTypeEnum.values()) {
            map.put(t.getCode(), t.getDes());
        }
        return map;
    }
}
