package com.biz.crm.tpm.business.audit.invoice.manage.sdk.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: chenlong
 * @date: 2023/1/7 10:02
 * @description: 发票类型
 */
public enum InvoiceTypeEnum {

    TRAIN_TICKET("train_ticket", "火车票"),

    ROAD_BRIDGE("road_bridge", "路桥费发票"),

    AIR_TICKET("air_ticket", "行程单"),

    VATS_INVOICE("vats_invoice", "增值税专用发票"),

    VAT_INVOICE("vat_invoice", "增值税普通发票"),

    VATE_INVOICE("vate_invoice", "增值税电子普通发票"),

    TAXI_RECEIPT("taxi_receipt", "出租车票"),

    QUOTA_INVOICE("quota_invoice", "定额发票"),

    TVATS_INVOICE("tvats_invoice", "货物运输业增值税专用发票"),

    COIL_INVOICE("coil_invoice", "增值税普通发票（卷式）"),

    INVOICE("invoice", "机打发票"),

    BUS_TICKET("bus_ticket", "汽车票"),

    CAR_INVOICE("car_invoice", "机动车销售统一发票"),

    RECEIPT("receipt", "其他发票"),

    CHAIN_INVOICE("chain_invoice", "区块链电子发票"),

    ENTRANCE_VAT("entrance_vat", "进口增值税"),

    ENTRANCE_CUSTOMS("entrance_customs", "进口关税"),

    ENTRANCE_VATS("entrance_vats", "海外专票"),

    BOAT_TICKET("boat_ticket", "船票"),

    SHOP_TICKET("shop_ticket", "商户小票"),

    GENER_INVOICE("gener_invoice", "通用(电子)发票"),

    VATES_INVOICE("vates_invoice", "增值税电子专用发票"),

    INVOICE_SALESLIST("invoice_saleslist", "销货清单"),

    ENTRANCE_RECEIPT("entrance_receipt", "海外票据"),

    AMOUNT_INVOICE("amount_invoice", "大量小额发票（注：批量提交的一堆公交车票或地铁票等，无需进行识别的票）"),

    PARKING_RECEIPT("parking_receipt", "停车费发票"),

    ENTRANCE_INCVATS("entrance_incvats", "海外专票（有税率）"),

    TOLL_INVOICE("toll_invoice", "通行费发票"),

    NONTAX_INVOICE("nontax_invoice", "非税收入通用票据"),

    MEDICAL_INVOICE("medical_invoice", "医疗费票据"),

    PRINTED_INVOICE("printed_invoice", "机打电子发票"),

    E_VATS_INVOICE("e_vats_invoice", "全电发票（专票）"),

    E_VAT_INVOICE("e_vat_invoice", "全电发票（普票）"),

    E_NON_GEN_INVOICE("e_non_gen_invoice", "非税收入一般缴款书"),

    E_DONATE_INVOICE("e_donate_invoice", "公益事业捐赠票据"),

    E_MEMBERSHIP_INVOICE("e_membership_invoice", "社会团体会费票据"),

    E_CAP_SETTLE_INVOICE("e_cap_settle_invoice", "行政事业单位资金往来结算票据"),

    E_ADV_SETTLE_INVOICE("e_adv_settle_invoice", "教育系统结算票据"),

    E_ROAD_TOLL_INVOICE("e_road_toll_invoice", "公路通行费财政票据"),
    ;

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    InvoiceTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static InvoiceTypeEnum codeToEnum(String code) {
        InvoiceTypeEnum invoiceTypeEnum = null;
        InvoiceTypeEnum[] var2 = values();

        for (InvoiceTypeEnum typeEnum : var2) {
            if (typeEnum.code.equals(code)) {
                invoiceTypeEnum = typeEnum;
            }
        }
        return invoiceTypeEnum;
    }

    /**
     * 转换为对应map
     *
     * @return java.util.Map<java.lang.String, java.lang.String>
     **/
    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (InvoiceTypeEnum t : InvoiceTypeEnum.values()) {
            map.put(t.getCode(), t.getDes());
        }
        return map;
    }
}
