package com.biz.crm.tpm.business.audit.invoice.manage.sdk.event.log;

import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author: chenlong
 * @date: 2022/11/14 10:21
 * @description: 结案核销发票管理日志监听
 */
public interface AuditInvoiceManageEventListener extends NebulaEvent {

    /**
     * 创建事件
     *
     * @param eventDto 事件dto
     */
    void onCreate(AuditInvoiceManageLogEventDto eventDto);

    /**
     * 删除事件
     *
     * @param eventDto 事件dto
     */
    void onDelete(AuditInvoiceManageLogEventDto eventDto);

    /**
     * 更新日志
     *
     * @param eventDto 事件dto
     */
    void onUpdate(AuditInvoiceManageLogEventDto eventDto);

    /**
     * 启用
     *
     * @param eventDto 事件dto
     */
    void onEnable(AuditInvoiceManageLogEventDto eventDto);

    /**
     * 禁用
     *
     * @param eventDto 事件dto
     */
    void onDisable(AuditInvoiceManageLogEventDto eventDto);
}
