package com.biz.crm.tpm.business.audit.invoice.manage.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceAuditDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.dto.AuditInvoiceManageDto;
import com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo.*;
import org.springframework.data.domain.Pageable;

import java.io.IOException;
import java.util.List;
import java.util.Set;

/**
 * @author: chenlong
 * @date: 2022/11/12 17:55
 * @description: 结案核销-发票管理表(AuditInvoice)表服务接口
 */
public interface AuditInvoiceManageService {

    /**
     * 分页查询所有数据
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询dto
     * @return 所有数据
     */
    Page<AuditInvoiceManageVo> findByConditions(Pageable pageable, AuditInvoiceManageDto auditInvoiceManageDto);

    /**
     * 分页查询有可用余额的数据(结案核销选择发票使用)
     *
     * @param pageable              分页对象
     * @param auditInvoiceManageDto 查询dto
     * @return 所有数据
     */
    Page<AuditInvoiceManageVo> findBalanceByConditions(Pageable pageable, AuditInvoiceManageDto auditInvoiceManageDto);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    AuditInvoiceManageVo findById(String id);

    /**
     * 新增数据(结案核销使用，同步方法)
     *
     * @param auditInvoiceManageDto dto对象
     */
    List<AuditInvoiceManageVo> create(AuditInvoiceManageDto auditInvoiceManageDto);

    /**
     * 新增数据(发票报销管理使用 异步)
     *
     * @param auditInvoiceManageDto dto对象
     */
    void createAsync(AuditInvoiceManageDto auditInvoiceManageDto, FacturerUserDetails identity);

    /**
     * 手动录入新增数据
     *
     * @param auditInvoiceManageDto dto对象
     */
    void manualCreate(AuditInvoiceManageDto auditInvoiceManageDto);

    /**
     * 手动录入编辑数据
     *
     * @param auditInvoiceManageDto dto对象
     */
    void manualUpdate(AuditInvoiceManageDto auditInvoiceManageDto);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     */
    void delete(List<String> idList);

    /**
     * 启用
     *
     * @param ids 主键列表
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids 主键列表
     */
    void disableBatch(List<String> ids);

    /**
     * 查找发票
     *
     * @param invoiceCodes 发票代码
     * @return
     */
    List<AuditInvoiceManageVo> findInvoices(Set<String> invoiceCodes);

    /**
     * 分页查询关联核销明细
     *
     * @param pageable 分页对象
     * @param auditDto 查询dto
     * @return 所有数据
     */
    Page<AuditInvoiceAuditVo> findAuditByConditions(Pageable pageable, AuditInvoiceAuditDto auditDto);


    void changeInvoices(List<AuditInvoiceManageDto> auditInvoiceManageDtos);

    void returnInvoices(List<AuditInvoiceManageDto> auditInvoiceManageDtos);

    /**
     * 通过发票号码和发票代码(可为空)查询单条数据，若代码为0则视为空
     *
     * @param dto 参数
     * @return 单条数据
     */
    AuditInvoiceManageVo findByNoAndCode(AuditInvoiceManageDto dto);

    /**
     * 根据发票id下载附件压缩包
     *
     * @param ids id列表
     * @return byte[]
     * @throws IOException 异常
     */
    byte[] findFileZipByIds(List<String> ids) throws IOException;

    /**
     * 根据发票号码下载附件压缩包
     *
     * @param invoiceNos 号码列表
     * @return byte[]
     * @throws IOException 异常
     */
    byte[] findFileZipByInvoiveNos(List<String> invoiceNos) throws IOException;


    /**
     * 根据编码查发票明细
     *
     * @param auditInvoiceManageDtos
     * @return
     */
    List<AuditInvoiceItemVo> findByInvoiceNoCode(List<AuditInvoiceManageDto> auditInvoiceManageDtos);

    /**
     * 根据编码查发票明细
     * @param invoiceCode
     * @param invoiceNumber
     * @return
     */
    List<AuditInvoiceItemVo> findInvoiceItem(String invoiceCode,String invoiceNumber);

    /**
     * 条件查询发票明细信息
     *
     * @param pageable
     * @param dto
     * @return
     */
    Page<AuditInvoiceManageItemExportVo> findAllConditions(Pageable pageable, AuditInvoiceManageDto dto);

    /**
     * 更新发票使用状态
     *
     * @param invoiceManageDtoList
     */
    void updateByNoAndCode(List<AuditInvoiceManageDto> invoiceManageDtoList,String isUse,String useDate);

    /**
     * 根据发票id查询发票附件
     *
     * @param ids
     * @return
     */
    List<AuditInvoiceManageFileSdkVo> findInvoiceFileData(List<String> ids);

    /**
     * 发票代码发票号码查找发票
     * @param dtoList
     * @return
     */
    List<AuditInvoiceManageVo> findByInvoiceNoCode2(List<AuditInvoiceManageDto> dtoList);
}
