package com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author: chenlong
 * @date: 2022/11/14 9:48
 * @description: 结案核销发票管理-关联核销明细Vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInvoiceAuditVo", description = "结案核销发票管理-关联核销明细Vo")
public class AuditInvoiceAuditVo extends TenantFlagOpDto {

    @ApiModelProperty(name = "核销code", notes = "核销code")
    private String auditCode;

    @ApiModelProperty(name = "核销名称", notes = "核销名称")
    private String auditName;

    @ApiModelProperty(name = "核销明细编码", notes = "核销明细编码")
    private String auditDetailCode;

    @ApiModelProperty(name = "客户编码", notes = "客户编码")
    private String customerCode;

    @ApiModelProperty(name = "客户名称", notes = "客户名称")
    private String customerName;

    @ApiModelProperty(name = "零售商编码", notes = "零售商编码")
    private String systemCode;

    @ApiModelProperty(name = "零售商名称", notes = "零售商名称")
    private String systemName;

    @ApiModelProperty(name = "是否完全结案", notes = "是否完全结案")
    private String wholeAudit;

    @ApiModelProperty(name = "预核销金额", notes = "预核销金额")
    private BigDecimal auditAmount;

    @ApiModelProperty(name = "已结案金额", notes = "已结案金额")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty(name = "剩余应核销金额", notes = "剩余应核销金额")
    private BigDecimal surplusAuditAmount;

    @ApiModelProperty(name = "申请金额", notes = "申请金额")
    private BigDecimal applyAmount;

    @ApiModelProperty(name = "本次结案金额", notes = "本次结案金额")
    private BigDecimal thisAuditAmount;

}
