package com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo;

import com.alibaba.fastjson.annotation.JSONField;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @Author : dengwei
 * @Date :2023/8/7  20:42
 * @Description: TODO
 */
@ApiModel(value = "AuditInvoiceManageExportVo",description = "vo")
@Getter
@Setter
@CrmExcelExport
public class AuditInvoiceManageExportVo  extends CrmExcelVo {
    @ApiModelProperty(name = "业态", notes = "业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("发票类型")
    @CrmExcelColumn("发票类型")
    private String invoiceType;

    @ApiModelProperty("发票代码")
    @CrmExcelColumn("发票代码")
    private String invoiceCode;

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    @CrmExcelColumn("发票号码")
    private String invoiceNo;

    @ApiModelProperty("开票日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @CrmExcelColumn("开票日期")
    private Date billingDate;

    @ApiModelProperty("是否使用")
    @CrmExcelColumn("是否使用")
    private String isUse;

    @ApiModelProperty("发票使用年月")
    @CrmExcelColumn("发票使用年月")
    private String useYears;

    @ApiModelProperty("校验码(只允许填写数字和字母)")
    @CrmExcelColumn("校验码")
    private String checkCode;

    @ApiModelProperty("货物或应税劳务名称")
    @CrmExcelColumn("货物或应税劳务名称")
    private String goodsTaxableName;

    @ApiModelProperty("购买方名称")
    @CrmExcelColumn("购买方名称")
    private String purchaser;

    @ApiModelProperty("购买方税号")
    @CrmExcelColumn("购买方纳税人识别号")
    private String pNo;

    @ApiModelProperty("购买方地址电话")
    @CrmExcelColumn("购买方地址,电话")
    private String pAddressAndPhone;

    @ApiModelProperty("购买方开户行及账号")
    @CrmExcelColumn("购买方开户行及账号")
    private String pBankAndAccount;

    @ApiModelProperty("销售方名称")
    @CrmExcelColumn("销售方名称")
    private String seller;

    @ApiModelProperty("销售方税号")
    @CrmExcelColumn("销售方纳税人识别号")
    private String sNo;

    @ApiModelProperty("销售方地址电话")
    @CrmExcelColumn("销售方地址,电话")
    private String sAddressAndPhone;

    @ApiModelProperty("销售方开户行及账号")
    @CrmExcelColumn("销售方开户行及账号")
    private String sBankAndAccount;

    @ApiModelProperty("税价合计(含税金额)")
    @CrmExcelColumn("发票金额(含税)")
    private BigDecimal priceAndTax;

    @ApiModelProperty("不含税金额")
    @CrmExcelColumn("发票金额（未税）")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("税额")
    @CrmExcelColumn("税额（元）")
    private BigDecimal taxAmount;

    @ApiModelProperty("税率")
    @CrmExcelColumn("税率")
    private BigDecimal taxRate;

    @ApiModelProperty("已使用金额")
    @CrmExcelColumn("已使用金额")
    private BigDecimal useAmount;

    @ApiModelProperty("可用余额")
    @CrmExcelColumn("可用余额")
    private BigDecimal ableAmount;

    @CrmExcelColumn("提交人")
    private String createName;

    @ApiModelProperty(name = "组织编码", notes = "组织编码")
    @CrmExcelColumn("组织编码")
    private String orgCode;

    @ApiModelProperty(name = "组织名称", notes = "组织名称")
    @CrmExcelColumn("组织名称")
    private String orgName;

    @ApiModelProperty(name = "createTime", value = "创建时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @CrmExcelColumn("创建时间")
    private Date createTime;
}
