package com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;

/**
 * 发票附件信息
 *
 * @author hd
 */
@Data
public class AuditInvoiceManageFileSdkVo {

    @ApiModelProperty("发票编码(系统自动生成)")
    private String invoiceCrmCode;

    @ApiModelProperty("发票号码(只允许填写数字和字母)")
    private String invoiceNo;

    @ApiModelProperty("文件唯一识别号")
    private String fileCode;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("文件大小")
    private Integer fileSize;

    @ApiModelProperty("有效期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date effectiveDate;

    @ApiModelProperty("相对路径")
    private String relativeLocal;

    @ApiModelProperty(name = "原始文件名", notes = "原始文件名")
    private String originalFileName;

    @ApiModelProperty("文件后缀")
    private String prefix;

    @ApiModelProperty("提交人")
    private String commitUser;
}
