package com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo;

import com.biz.crm.business.common.sdk.dto.FileDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/11/16 17:48
 * @description: 结案核销发票管理文件Vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInvoiceManageFileVo", description = "结案核销发票管理文件Vo")
public class AuditInvoiceManageFileVo extends FileDto {

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("文件大小")
    private Integer fileSize;

    @ApiModelProperty("有效期")
    private Date effectiveDate;

    @ApiModelProperty("相对路径")
    private String relativeLocal;

    @ApiModelProperty("uid")
    private String uid;

    @ApiModelProperty("文件后缀")
    private String prefix;

    @ApiModelProperty("提交人")
    private String commitUser;
}
