package com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelExport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 发票管理明细导出vo
 * @author hdy
 */
@ApiModel(value = "AuditInvoiceManageItemExportVo", description = "发票管理明细导出vo")
@Getter
@Setter
@CrmExcelExport
public class AuditInvoiceManageItemExportVo extends CrmExcelVo {

    @ApiModelProperty("行号")
    @CrmExcelColumn("行号")
    private String itemNo;

    @ApiModelProperty(name = "业态", notes = "业态")
    @CrmExcelColumn("业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @CrmExcelColumn("业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "发票类型", notes = "发票类型")
    @CrmExcelColumn("发票类型")
    private String invoiceType;

    @ApiModelProperty(name = "发票代码", notes = "发票代码")
    @CrmExcelColumn("发票代码")
    private String invoiceCode;

    @ApiModelProperty(name = "发票号码", notes = "发票号码")
    @CrmExcelColumn("发票号码")
    private String invoiceNo;

    @CrmExcelColumn("开票日期")
    @ApiModelProperty("开票日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date billingDate;

    @ApiModelProperty("校验码(只允许填写数字和字母)")
    @CrmExcelColumn("校验码")
    private String checkCode;

    @ApiModelProperty("购买方名称")
    @CrmExcelColumn("购买方名称")
    private String purchaser;

    @ApiModelProperty("购买方税号")
    @CrmExcelColumn("购买方纳税人识别号")
    private String pNo;

    @ApiModelProperty("购买方开户行及账号")
    @CrmExcelColumn("购买方开户行及账户")
    private String pBankAndAccount;

    @ApiModelProperty("购买方地址电话")
    @CrmExcelColumn("购买方地址、电话")
    private String pAddressAndPhone;

    @ApiModelProperty("销售方名称")
    @CrmExcelColumn("销售方名称")
    private String seller;

    @ApiModelProperty("销售方税号")
    @CrmExcelColumn("销售方纳税人识别号")
    private String sNo;

    @ApiModelProperty("销售方开户行及账号")
    @CrmExcelColumn("销售方开户行及账户")
    private String sBankAndAccount;

    @ApiModelProperty("销售方地址电话")
    @CrmExcelColumn("销售方地址、电话")
    private String sAddressAndPhone;

    @ApiModelProperty("商品编码")
    @CrmExcelColumn("商品编码")
    private String goodsCode;

    @ApiModelProperty("货物或应税劳务名称")
    @CrmExcelColumn("货物或应税劳务名称")
    private String goodsTaxableName;

    @ApiModelProperty("规格型号/航班号/车次")
    @CrmExcelColumn("规格型号/航班号/车次")
    private String specModel;

    @ApiModelProperty("单位/舱位/座席")
    @CrmExcelColumn("单位/舱位/座席")
    private String unitSeat;

    @ApiModelProperty("购买数量 0 无效")
    @CrmExcelColumn("购买数量")
    private BigDecimal purchaseQuantity;

    @ApiModelProperty("单价")
    @CrmExcelColumn("单价")
    private BigDecimal unitPrice;

    @ApiModelProperty(name = "发票金额（含税）", notes = "发票金额（含税）")
    @CrmExcelColumn("发票金额(含税)")
    private BigDecimal invoiceTaxAmount;

    @ApiModelProperty(name = "发票金额（未税）", notes = "发票金额（未税）")
    @CrmExcelColumn("发票金额(未税)")
    private BigDecimal amount;

    @ApiModelProperty(name = "税额（元）", notes = "税额（元）")
    @CrmExcelColumn("税额(元)")
    private BigDecimal tax;

    @ApiModelProperty(name = "税率", notes = "税率")
    @CrmExcelColumn("税率(%)")
    private BigDecimal taxRate;

    @ApiModelProperty("已使用金额")
    @CrmExcelColumn("已使用金额(元)")
    private BigDecimal useAmount;

    @ApiModelProperty("可用余额")
    @CrmExcelColumn("可用余额(元)")
    private BigDecimal ableAmount;

    @ApiModelProperty("车牌号")
    @CrmExcelColumn("车牌号")
    private String carLicense;

    @ApiModelProperty("通行日期始出发日期时间字符串")
    @CrmExcelColumn("通行日期始")
    private String startDate;

    @ApiModelProperty("通行日期止出发日期时间字符串")
    @CrmExcelColumn("通行日期止")
    private String endDate;

    @ApiModelProperty("城市名称用,隔开")
    @CrmExcelColumn("城市名称")
    private String cityName;

    @ApiModelProperty("城市编号用,隔开")
    @CrmExcelColumn("城市编号")
    private String cityCode;

    @ApiModelProperty("提交人")
    @CrmExcelColumn("提交人")
    private String createName;

}
