package com.biz.crm.tpm.business.audit.invoice.manage.sdk.vo;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author: chenlong
 * @date: 2022/11/14 9:48
 * @description: 发票上传消息推送Vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "AuditInvoiceManageMsgVo", description = "发票上传消息推送Vo")
public class AuditInvoiceManageMsgVo extends TenantFlagOpDto {

    @ApiModelProperty("文件编码")
    private String fileCode;

    @ApiModelProperty("文件名")
    private String fileName;

    @ApiModelProperty("识别状态")
    private String checkType;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("时间")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date time;

    @ApiModelProperty("当前登录人账号")
    private String account;

    @ApiModelProperty("websocket状态")
    private String execStatus;
}
