/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.plan.check.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckAccountDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckDifferenceDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckExpensesDeductDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.service.AuditPlanCheckAccountService;
import com.biz.crm.tpm.business.audit.plan.check.sdk.vo.AuditPlanCheckAccountDetailVo;
import com.biz.crm.tpm.business.audit.plan.check.sdk.vo.AuditPlanCheckAccountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/auditPlanCheck"})
@Api(tags={"\u65b9\u6848\u6838\u5bf9\u53f0\u8d26"})
public class AuditPlanCheckAccountController {
    private static final Logger log = LoggerFactory.getLogger(AuditPlanCheckAccountController.class);
    @Autowired(required=false)
    private AuditPlanCheckAccountService auditPlanCheckAccountService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<AuditPlanCheckAccountVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="dto", value="\u8d39\u7528\u6838\u5bf9\u53f0\u8d26") AuditPlanCheckAccountDto dto) {
        try {
            Page page = this.auditPlanCheckAccountService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be6\u60c5")
    @GetMapping(value={"/findById"})
    public Result<AuditPlanCheckAccountVo> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eID") String id) {
        try {
            AuditPlanCheckAccountVo vo = this.auditPlanCheckAccountService.findById(id);
            return Result.ok((Object)vo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u7f16\u8f91\u6570\u636e")
    @PostMapping(value={"/saveAuditPlanCheckAccount"})
    public Result<?> saveAuditPlanCheckAccount(@ApiParam(name="dto", value="\u672a\u5339\u914d\u7ed3\u7b97\u5355") @RequestBody AuditPlanCheckAccountDto dto) {
        try {
            this.auditPlanCheckAccountService.saveAccount(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@ApiParam(name="ids", value="\u4e3b\u952e\u96c6\u5408") @RequestParam(value="ids") List<String> ids) {
        try {
            this.auditPlanCheckAccountService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6570\u636e\u62bd\u53d6")
    @GetMapping(value={"/extractData"})
    public Result extractData() {
        try {
            this.auditPlanCheckAccountService.extractData();
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6263\u8d39\u5206\u644a")
    @PatchMapping(value={"/expensesDeduct"})
    public Result<?> expensesDeduct(@ApiParam(name="dto", value="\u6263\u8d39\u5206\u644a") @RequestBody AuditPlanCheckExpensesDeductDto dto) {
        try {
            this.auditPlanCheckAccountService.expensesDeduct(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5dee\u5f02\u6838\u5bf9")
    @PatchMapping(value={"/difference"})
    public Result<?> difference(@ApiParam(name="dto", value="\u5dee\u5f02\u6838\u5bf9") @RequestBody AuditPlanCheckDifferenceDto dto) {
        try {
            this.auditPlanCheckAccountService.difference(dto);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u786e\u8ba4")
    @PatchMapping(value={"/confirm"})
    public Result<?> confirm(@RequestBody List<String> ids) {
        try {
            this.auditPlanCheckAccountService.confirm(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5173\u8054\u6263\u8d39\u7f16\u7801")
    @PostMapping(value={"/findRelateMatchCode"})
    public Result<List<AuditPlanCheckAccountDetailVo>> findRelateMatchCode(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam(value="id") String id) {
        try {
            List list = this.auditPlanCheckAccountService.findRelateMatchCode(id);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

