/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.plan.check.local.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.audit.plan.check.sdk.service.AuditPlanCheckAccountService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class AuditPlanCheckAccountAutoXxlJob {
    private static final Logger log = LoggerFactory.getLogger(AuditPlanCheckAccountAutoXxlJob.class);
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private AuditPlanCheckAccountService auditPlanCheckAccountService;

    @DynamicTaskService(cornExpression="0 0 2 * * ?", taskDesc="\u5b9a\u65f6\u66f4\u65b0\u65b9\u6848\u6838\u5bf9\u53f0\u8d26\u6570\u636e")
    public void autoExtractPlanCheckAccountData() {
        this.loginUserService.refreshAuthentication(null);
        boolean lockSuccess = false;
        try {
            lockSuccess = this.redisLockService.tryLock("audit:planCheckConstant:lock:", TimeUnit.HOURS, 3L);
            Assert.isTrue((boolean)lockSuccess, (String)"\u5176\u4ed6\u4eba\u6b63\u5728\u64cd\u4f5c\u6570\u636e,\u52a0\u9501\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5!");
            this.auditPlanCheckAccountService.extractData();
        }
        catch (Exception e) {
            log.error("\u5b9a\u65f6\u66f4\u65b0\u65b9\u6848\u6838\u5bf9\u53f0\u8d26\u6570\u636e\u5f02\u5e38");
            log.error("", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        finally {
            if (lockSuccess) {
                this.redisLockService.unlock("audit:planCheckConstant:lock:");
            }
        }
    }
}

