/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.plan.check.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.plan.check.local.entity.AuditPlanCheckAccountDetail;
import com.biz.crm.tpm.business.audit.plan.check.local.repository.AuditPlanCheckAccountDetailRepository;
import com.biz.crm.tpm.business.audit.plan.check.local.service.AuditPlanCheckAccountDetailService;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckAccountDetailDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckAccountDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.vo.AuditPlanCheckAccountDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AuditPlanCheckAccountDetailServiceImpl
implements AuditPlanCheckAccountDetailService {
    private static final Logger log = LoggerFactory.getLogger(AuditPlanCheckAccountDetailServiceImpl.class);
    @Autowired(required=false)
    private AuditPlanCheckAccountDetailRepository auditPlanCheckAccountDetailRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void save(AuditPlanCheckAccountDto dto) {
        if (Objects.isNull(dto) || CollectionUtils.isEmpty((Collection)dto.getMatchedCodeList())) {
            return;
        }
        this.auditPlanCheckAccountDetailRepository.remove((Wrapper)Wrappers.lambdaUpdate(AuditPlanCheckAccountDetail.class).eq(AuditPlanCheckAccountDetail::getAccountCode, (Object)dto.getAccountCode()));
        Collection detailList = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getMatchedCodeList(), AuditPlanCheckAccountDetailDto.class, AuditPlanCheckAccountDetail.class, HashSet.class, ArrayList.class, new String[0]);
        detailList.forEach(detail -> {
            detail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detail.setTenantCode(TenantUtils.getTenantCode());
            detail.setAccountCode(dto.getAccountCode());
        });
        this.auditPlanCheckAccountDetailRepository.saveBatch(detailList);
    }

    @Override
    public List<AuditPlanCheckAccountDetailVo> findByAccountCode(String accountCode) {
        if (StringUtils.isBlank((CharSequence)accountCode)) {
            return Lists.newArrayList();
        }
        List<AuditPlanCheckAccountDetail> detailList = this.auditPlanCheckAccountDetailRepository.findByAccountCode(accountCode);
        if (CollectionUtils.isEmpty(detailList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, AuditPlanCheckAccountDetail.class, AuditPlanCheckAccountDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public List<AuditPlanCheckAccountDetailVo> findByAccountCodes(List<String> accountCodes) {
        if (CollectionUtils.isEmpty(accountCodes)) {
            return Lists.newArrayList();
        }
        List<AuditPlanCheckAccountDetail> detailList = this.auditPlanCheckAccountDetailRepository.findByAccountCodes(accountCodes);
        if (CollectionUtils.isEmpty(detailList)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(detailList, AuditPlanCheckAccountDetail.class, AuditPlanCheckAccountDetailVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Override
    public void deleteByAccountCodes(List<String> accountCodes) {
        if (CollectionUtils.isEmpty(accountCodes)) {
            return;
        }
        this.auditPlanCheckAccountDetailRepository.remove((Wrapper)Wrappers.lambdaUpdate(AuditPlanCheckAccountDetail.class).in(AuditPlanCheckAccountDetail::getAccountCode, accountCodes));
    }
}

