/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.audit.plan.check.local.service.internal;

import cn.hutool.core.util.NumberUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigSearchDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.check.AuditFeeCheckDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDetailDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.dispose.AuditFeeDiffDisposeDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDto;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.AuditStateEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.enumeration.MatchStatusEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckDetailPlanVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.check.AuditFeeCheckVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.dispose.AuditFeeDiffDisposeVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.service.ledger.AuditFeeDiffLedgerVoService;
import com.biz.crm.tpm.business.audit.fee.sdk.template.enums.DeductionMatchingTemplateTypeEnum;
import com.biz.crm.tpm.business.audit.fee.sdk.template.service.TpmDeductionMatchingTemplateService;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckCostVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckDetailPlanVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.check.AuditFeeCheckVo;
import com.biz.crm.tpm.business.audit.fee.sdk.vo.dispose.AuditFeeDiffDisposeTemplateVo;
import com.biz.crm.tpm.business.audit.plan.check.local.entity.AuditPlanCheckAccount;
import com.biz.crm.tpm.business.audit.plan.check.local.repository.AuditPlanCheckAccountRepository;
import com.biz.crm.tpm.business.audit.plan.check.local.service.AuditPlanCheckAccountDetailService;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckAccountDetailDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckAccountDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckDifferenceDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.AuditPlanCheckExpensesDeductDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.dto.log.AuditPlanCheckAccountLogEventDto;
import com.biz.crm.tpm.business.audit.plan.check.sdk.enums.MatchingConditionEnum;
import com.biz.crm.tpm.business.audit.plan.check.sdk.event.AuditPlanCheckAccountLogEventListener;
import com.biz.crm.tpm.business.audit.plan.check.sdk.service.AuditPlanCheckAccountService;
import com.biz.crm.tpm.business.audit.plan.check.sdk.vo.AuditPlanCheckAccountDetailVo;
import com.biz.crm.tpm.business.audit.plan.check.sdk.vo.AuditPlanCheckAccountVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class AuditPlanCheckAccountServiceImpl
implements AuditPlanCheckAccountService {
    private static final Logger log = LoggerFactory.getLogger(AuditPlanCheckAccountServiceImpl.class);
    @Autowired(required=false)
    private AuditPlanCheckAccountRepository auditPlanCheckAccountRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private AuditFeeCheckVoService auditFeeCheckVoService;
    @Autowired(required=false)
    private AuditFeeDiffLedgerVoService auditFeeDiffLedgerVoService;
    @Autowired(required=false)
    private AuditFeeDiffDisposeVoService auditFeeDiffDisposeVoService;
    @Autowired(required=false)
    private TpmDeductionMatchingTemplateService tpmDeductionMatchingTemplateService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private AuditPlanCheckAccountDetailService auditPlanCheckAccountDetailService;
    @Autowired(required=false)
    private AuditFeeCheckDetailPlanVoService auditFeeCheckDetailPlanVoService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    public Page<AuditPlanCheckAccountVo> findByConditions(Pageable pageable, AuditPlanCheckAccountDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)1, (int)50));
        dto = Optional.ofNullable(dto).orElse(new AuditPlanCheckAccountDto());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.auditPlanCheckAccountRepository.findByConditions((Page<AuditPlanCheckAccountVo>)page, dto);
    }

    public AuditPlanCheckAccountVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        AuditPlanCheckAccount account = (AuditPlanCheckAccount)((Object)this.auditPlanCheckAccountRepository.getById((Serializable)((Object)id)));
        return (AuditPlanCheckAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)account, AuditPlanCheckAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public List<AuditPlanCheckAccountVo> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<AuditPlanCheckAccount> list = this.auditPlanCheckAccountRepository.getByIds(ids);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        List accountVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, AuditPlanCheckAccount.class, AuditPlanCheckAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
        accountVos.forEach(accountVo -> {
            List<AuditPlanCheckAccountDetailVo> detailVoList = this.auditPlanCheckAccountDetailService.findByAccountCode(accountVo.getTenantCode());
            if (!CollectionUtils.isEmpty(detailVoList)) {
                accountVo.setMatchedCodeList(detailVoList);
            }
        });
        return accountVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveAccount(AuditPlanCheckAccountDto dto) {
        boolean update;
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        boolean bl = update = !StringUtils.isBlank((CharSequence)dto.getId());
        if (!update) {
            String code = (String)this.generateCodeService.generateCode("FAHD", 1, Integer.valueOf(5), 2L, TimeUnit.DAYS).get(0);
            dto.setAccountCode(code);
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            AuditPlanCheckAccount entity = (AuditPlanCheckAccount)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditPlanCheckAccount.class, HashSet.class, ArrayList.class, new String[0]));
            AuditPlanCheckAccountLogEventDto logEventDto = new AuditPlanCheckAccountLogEventDto();
            logEventDto.setOriginal(null);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onCreate = AuditPlanCheckAccountLogEventListener::onCreate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditPlanCheckAccountLogEventListener.class, (SerializableBiConsumer)onCreate);
            this.auditPlanCheckAccountRepository.save((Object)entity);
        } else {
            AuditPlanCheckAccount old = (AuditPlanCheckAccount)((Object)this.auditPlanCheckAccountRepository.getById((Serializable)((Object)dto.getId())));
            Validate.notNull((Object)((Object)old), (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6570\u636e\uff01", (Object[])new Object[0]);
            AuditPlanCheckAccountVo oldVo = (AuditPlanCheckAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)old, AuditPlanCheckAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            AuditPlanCheckAccountLogEventDto logEventDto = new AuditPlanCheckAccountLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(dto);
            SerializableBiConsumer & Serializable onUpdate = AuditPlanCheckAccountLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditPlanCheckAccountLogEventListener.class, (SerializableBiConsumer)onUpdate);
            AuditPlanCheckAccount entity = (AuditPlanCheckAccount)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, AuditPlanCheckAccount.class, HashSet.class, ArrayList.class, new String[0]));
            this.auditPlanCheckAccountRepository.updateById((Object)entity);
        }
        this.auditPlanCheckAccountDetailService.save(dto);
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        List<AuditPlanCheckAccount> entityList = this.auditPlanCheckAccountRepository.getByIds(ids);
        entityList.forEach(entity -> {
            AuditPlanCheckAccountVo oldVo = (AuditPlanCheckAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditPlanCheckAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
            entity.setDelFlag(DelFlagStatusEnum.DELETE.getDes());
            AuditPlanCheckAccountDto newDto = (AuditPlanCheckAccountDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, AuditPlanCheckAccountDto.class, HashSet.class, ArrayList.class, new String[0]);
            AuditPlanCheckAccountLogEventDto logEventDto = new AuditPlanCheckAccountLogEventDto();
            logEventDto.setOriginal(oldVo);
            logEventDto.setNewest(newDto);
            SerializableBiConsumer & Serializable onUpdate = AuditPlanCheckAccountLogEventListener::onUpdate;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, AuditPlanCheckAccountLogEventListener.class, (SerializableBiConsumer)onUpdate);
        });
        this.auditPlanCheckAccountRepository.updateBatchById(entityList);
        List<String> accountCodes = entityList.stream().map(AuditPlanCheckAccount::getAccountCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        this.auditPlanCheckAccountDetailService.deleteByAccountCodes(accountCodes);
    }

    private void saveAccounts(List<AuditPlanCheckAccountDto> accountList) {
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        accountList.forEach(account -> this.saveAccount((AuditPlanCheckAccountDto)account));
    }

    public void difference(AuditPlanCheckDifferenceDto dto) {
        Validate.notEmpty((Collection)dto.getIds(), (String)"\u4e3b\u5efaid\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditPlanCheckAccount> accountList = this.auditPlanCheckAccountRepository.getByIds(dto.getIds());
        Validate.isTrue((!CollectionUtils.isEmpty(accountList) ? 1 : 0) != 0, (String)"\u9009\u62e9\u7684\u6570\u636e\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        List<String> accountCodes = accountList.stream().map(AuditPlanCheckAccount::getAccountCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List<AuditPlanCheckAccountDetailVo> accountDetailVoList = this.auditPlanCheckAccountDetailService.findByAccountCodes(accountCodes);
        Map<String, List<AuditPlanCheckAccountDetailVo>> accountDetailVoMap = accountDetailVoList.stream().collect(Collectors.groupingBy(AuditPlanCheckAccountDetailVo::getAccountCode));
        List matchCodes = accountDetailVoList.stream().map(AuditPlanCheckAccountDetailVo::getMatchCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List detailPlans = this.auditFeeCheckDetailPlanVoService.findDetailByMatchCodes(matchCodes);
        Validate.notEmpty((Collection)detailPlans, (String)"\u672a\u67e5\u8be2\u5230\u7ec6\u6848\u5173\u8054\u6570\u636e", (Object[])new Object[0]);
        Map<String, List<AuditFeeCheckDetailPlanVo>> detailPlansMap = detailPlans.stream().collect(Collectors.groupingBy(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode));
        Set itemCodes = detailPlans.stream().map(o -> o.getDetailPlanItemCode()).collect(Collectors.toSet());
        List activityDetailPlanItemVos = this.activityDetailPlanItemSdkService.listByItemCodeList(new ArrayList(itemCodes));
        Validate.notEmpty((Collection)activityDetailPlanItemVos, (String)"\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u7ec6\u6848\u6570\u636e", (Object[])new Object[0]);
        Map itemVoMap = activityDetailPlanItemVos.stream().collect(Collectors.toMap(ActivityDetailPlanItemBase::getDetailPlanItemCode, Function.identity()));
        Set configCodes = activityDetailPlanItemVos.stream().map(o -> o.getTemplateConfigCode()).collect(Collectors.toSet());
        List configVoList = this.activitiesTemplateSdkService.findByCodeList(new ArrayList(configCodes));
        Validate.notEmpty((Collection)configVoList, (String)"\u672a\u67e5\u8be2\u5230\u6d3b\u52a8\u6a21\u677f\u914d\u7f6e", (Object[])new Object[0]);
        Map configVoMap = configVoList.stream().collect(Collectors.toMap(ActivitiesTemplateConfigVo::getConfigCode, Function.identity()));
        if (Objects.nonNull(dto.getPositiveDifferenceAmount()) && dto.getPositiveDifferenceAmount().compareTo(BigDecimal.ZERO) != 0) {
            for (AuditPlanCheckAccount account : accountList) {
                if (CollectionUtils.isEmpty(accountDetailVoMap)) continue;
                List<AuditPlanCheckAccountDetailVo> detailList = accountDetailVoMap.get(account.getAccountCode());
                detailList.forEach(detail -> {
                    AuditFeeDiffLedgerDto ledgerDto = new AuditFeeDiffLedgerDto();
                    ledgerDto.setAuditFeeCheckCode(detail.getMatchCode());
                    ledgerDto.setFeeYearMonth(account.getFeeYearMonth());
                    if (Objects.nonNull(ledgerDto.getFeeYearMonth())) {
                        ledgerDto.setYear(ledgerDto.getFeeYearMonth().split("-")[0]);
                        ledgerDto.setMonth(ledgerDto.getFeeYearMonth().split("-")[1]);
                    }
                    ledgerDto.setBusinessFormatCode(account.getBusinessFormatCode());
                    ledgerDto.setBusinessUnitCode(account.getBusinessUnitCode());
                    ledgerDto.setStatus(AuditStateEnum.WAIT_CONFIRM.getCode());
                    ledgerDto.setRetailerCode(account.getCustomerRetailerCode());
                    ledgerDto.setRetailerName(account.getCustomerRetailerName());
                    ledgerDto.setBusinessAreaCode(account.getBusinessArea());
                    ledgerDto.setSalesOrgCode(account.getSalesOrgCode());
                    ledgerDto.setSalesOrgName(account.getSalesOrgName());
                    List auditFeeCheckDetailPlans = (List)detailPlansMap.get(detail.getMatchCode());
                    BigDecimal activityPreAuditTotalAmount = BigDecimal.ZERO;
                    for (AuditFeeCheckDetailPlanVo auditFeeCheckDetailPlan : auditFeeCheckDetailPlans) {
                        if (!Objects.nonNull(auditFeeCheckDetailPlan.getPredictionAuditAmount())) continue;
                        activityPreAuditTotalAmount = activityPreAuditTotalAmount.add(auditFeeCheckDetailPlan.getPredictionAuditAmount());
                    }
                    Map<String, List<AuditFeeCheckDetailPlanVo>> map = detailPlans.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o.getActivityTypeCode())).collect(Collectors.groupingBy(AuditFeeCheckDetailPlanVo::getActivityTypeCode));
                    for (Map.Entry<String, List<AuditFeeCheckDetailPlanVo>> entry : map.entrySet()) {
                        BigDecimal activityPreAuditKeyAmount = BigDecimal.ZERO;
                        for (AuditFeeCheckDetailPlanVo plan : entry.getValue()) {
                            if (!Objects.nonNull(plan.getPredictionAuditAmount())) continue;
                            activityPreAuditKeyAmount = activityPreAuditKeyAmount.add(plan.getPredictionAuditAmount());
                        }
                        if (NumberUtil.equals((BigDecimal)activityPreAuditTotalAmount, (BigDecimal)BigDecimal.ZERO)) continue;
                        BigDecimal mul = NumberUtil.mul((Number)activityPreAuditKeyAmount, (Number)dto.getPositiveDifferenceAmount());
                        ledgerDto.setDiffAmount(NumberUtil.equals((BigDecimal)activityPreAuditTotalAmount, (BigDecimal)BigDecimal.ZERO) ? BigDecimal.ZERO : NumberUtil.div((Number)mul, (Number)activityPreAuditTotalAmount));
                        ledgerDto.setActivitiesType(entry.getKey());
                        ledgerDto.setDataSource("AuditPlanCheckAccountService");
                        this.auditFeeDiffLedgerVoService.create(ledgerDto);
                    }
                });
            }
        }
        if (Objects.nonNull(dto.getNegativeDifferenceAmount()) && dto.getNegativeDifferenceAmount().compareTo(BigDecimal.ZERO) != 0) {
            for (AuditPlanCheckAccount account : accountList) {
                AuditFeeDiffDisposeDto diffDisposeDto = new AuditFeeDiffDisposeDto();
                diffDisposeDto.setBusinessFormatCode(account.getBusinessFormatCode());
                diffDisposeDto.setBusinessUnitCode(account.getBusinessUnitCode());
                diffDisposeDto.setDisposeFeeAmount(dto.getNegativeDifferenceAmount());
                StringBuilder nameBuilder = new StringBuilder();
                nameBuilder.append(StringUtils.isNotBlank((CharSequence)account.getBusinessArea()) ? account.getBusinessArea() : "").append(StringUtils.isNotBlank((CharSequence)account.getCustomerRetailerCode()) ? account.getCustomerRetailerCode() : "").append(StringUtils.isNotBlank((CharSequence)dto.getReason()) ? dto.getReason() : "").append("(\u81ea\u52a8\u751f\u6210)");
                diffDisposeDto.setFeeDiffDisposeName(nameBuilder.toString());
                if (CollectionUtils.isEmpty(accountDetailVoMap)) continue;
                List<AuditPlanCheckAccountDetailVo> detailList = accountDetailVoMap.get(account.getAccountCode());
                detailList.forEach(detail -> {
                    List auditFeeCheckDetailPlans = (List)detailPlansMap.get(detail.getMatchCode());
                    ArrayList<AuditFeeDiffDisposeTemplateVo> templateVos = new ArrayList<AuditFeeDiffDisposeTemplateVo>();
                    ArrayList<AuditFeeDiffDisposeDetailDto> disposeDetailDtos = new ArrayList<AuditFeeDiffDisposeDetailDto>();
                    for (AuditFeeCheckDetailPlanVo detailPlan : auditFeeCheckDetailPlans) {
                        ActivityDetailPlanItemVo itemVo = (ActivityDetailPlanItemVo)itemVoMap.get(detailPlan.getDetailPlanItemCode());
                        ActivitiesTemplateConfigVo configVo = (ActivitiesTemplateConfigVo)configVoMap.get(itemVo.getTemplateConfigCode());
                        if (!Objects.nonNull(configVo) || !StringUtils.isNotBlank((CharSequence)account.getBusinessFormatCode()) || !StringUtils.isNotBlank((CharSequence)account.getBusinessUnitCode()) || !StringUtils.isNotBlank((CharSequence)configVo.getConfigName())) continue;
                        PageRequest pageRequest = PageRequest.of((int)1, (int)50);
                        ActivitiesTemplateConfigSearchDto searchDto = new ActivitiesTemplateConfigSearchDto();
                        searchDto.setBusinessFormatCode(account.getBusinessFormatCode());
                        searchDto.setBusinessUnitCode(account.getBusinessUnitCode());
                        searchDto.setType(ActivitiesTemplateConfigTypeEnum.DIFF_FEE_DISPOSE.getCode());
                        searchDto.setConfigName(configVo.getConfigName());
                        Page configVoPage = this.activitiesTemplateSdkService.findByConditions((Pageable)pageRequest, searchDto);
                        if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)configVoPage.getRecords())) continue;
                        ActivitiesTemplateConfigVo templateConfigVo = (ActivitiesTemplateConfigVo)configVoPage.getRecords().get(0);
                        AuditFeeDiffDisposeTemplateVo templateVo = new AuditFeeDiffDisposeTemplateVo();
                        templateVo.setTemplateConfigName(templateConfigVo.getConfigName());
                        templateVo.setTemplateConfigCode(templateConfigVo.getConfigCode());
                        templateVos.add(templateVo);
                        diffDisposeDto.setTemplateCodes(templateConfigVo.getConfigCode());
                        AuditFeeDiffDisposeDetailDto detailDto = new AuditFeeDiffDisposeDetailDto();
                        detailDto.setFeeDiffDisposeName(nameBuilder.toString());
                        detailDto.setTemplateConfigCode(templateConfigVo.getConfigCode());
                        detailDto.setTemplateConfigName(templateConfigVo.getConfigName());
                        disposeDetailDtos.add(detailDto);
                    }
                    diffDisposeDto.setTemplates(templateVos);
                    diffDisposeDto.setDetails(disposeDetailDtos);
                    this.auditFeeDiffDisposeVoService.autoCreate(diffDisposeDto);
                });
            }
        }
    }

    public void expensesDeduct(AuditPlanCheckExpensesDeductDto dto) {
        Optional<List> idsOpt = Optional.ofNullable(dto).map(AuditPlanCheckExpensesDeductDto::getIds);
        ArrayList updateAuditFeeChecks = new ArrayList();
        ArrayList updateAuditFeeCheckDetailPlans = new ArrayList();
        idsOpt.ifPresent(ids -> {
            List<AuditPlanCheckAccount> accountList = this.auditPlanCheckAccountRepository.getByIds((List<String>)ids);
            Validate.notEmpty(accountList, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5b9e\u4f8b\u5217\u8868", (Object[])new Object[0]);
            List<String> accountCodes = accountList.stream().map(AuditPlanCheckAccount::getAccountCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List<AuditPlanCheckAccountDetailVo> accountDetailVoList = this.auditPlanCheckAccountDetailService.findByAccountCodes(accountCodes);
            Map<String, List<AuditPlanCheckAccountDetailVo>> accountDetailVoMap = accountDetailVoList.stream().collect(Collectors.groupingBy(AuditPlanCheckAccountDetailVo::getAccountCode));
            List matchCodes = accountDetailVoList.stream().map(AuditPlanCheckAccountDetailVo::getMatchCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            List auditFeeCheckDetailPlans = this.auditFeeCheckDetailPlanVoService.findDetailByMatchCodes(matchCodes);
            if (CollectionUtils.isEmpty((Collection)auditFeeCheckDetailPlans)) {
                return;
            }
            Map<String, List<AuditFeeCheckDetailPlanVo>> detailPlanMap = auditFeeCheckDetailPlans.stream().collect(Collectors.groupingBy(AuditFeeCheckDetailPlanVo::getAuditFeeCheckCode));
            List auditFeeCheckVoList = this.auditFeeCheckVoService.getByMatchCodes(matchCodes);
            Map<String, List<AuditFeeCheckVo>> auditFeeCheckVoMap = auditFeeCheckVoList.stream().collect(Collectors.groupingBy(AuditFeeCheckVo::getMatchCode));
            for (int i = 0; i < accountList.size(); ++i) {
                AuditPlanCheckAccount account = accountList.get(i);
                BigDecimal totalPreAuditAmount = BigDecimal.ZERO;
                BigDecimal totalDiffAmount = BigDecimal.ZERO;
                if (CollectionUtils.isEmpty(accountDetailVoMap)) continue;
                List<AuditPlanCheckAccountDetailVo> accountDetailList = accountDetailVoMap.get(account.getAccountCode());
                for (AuditPlanCheckAccountDetailVo detailVo : accountDetailList) {
                    List<AuditFeeCheckDetailPlanVo> auditFeeCheckDetailPlanVos = detailPlanMap.get(detailVo.getMatchCode());
                    for (AuditFeeCheckDetailPlanVo detailPlan : auditFeeCheckDetailPlanVos) {
                        if (Objects.nonNull(detailPlan.getPredictionAuditAmount())) {
                            totalPreAuditAmount = totalPreAuditAmount.add(detailPlan.getPredictionAuditAmount());
                        }
                        totalDiffAmount = totalDiffAmount.add(this.calculateDiffAmount(account, accountDetailList, totalPreAuditAmount, auditFeeCheckVoMap));
                    }
                    BigDecimal tmpDiffAmount = BigDecimal.ZERO;
                    List<AuditFeeCheckVo> auditFeeCheckVos = auditFeeCheckVoMap.get(detailVo.getMatchCode());
                    if (totalPreAuditAmount.compareTo(BigDecimal.ZERO) != 0 || CollectionUtils.isEmpty(auditFeeCheckVos)) continue;
                    for (AuditFeeCheckVo check : auditFeeCheckVos) {
                        DeductionMatchingTemplateTypeEnum templateTypeEnum = DeductionMatchingTemplateTypeEnum.getTypeByCode((String)check.getMatchTemplateType());
                        Validate.notNull((Object)templateTypeEnum, (String)"\u672a\u77e5\u7684\u6a21\u677f\u7c7b\u578b", (Object[])new Object[0]);
                        BigDecimal tmpAmount = BigDecimal.ZERO;
                        switch (templateTypeEnum) {
                            case DETAIL_FEE_SETATEMENT: {
                                BigDecimal div1 = NumberUtil.div((Number)check.getCostDetailDiffAmount(), (Number)totalDiffAmount);
                                BigDecimal mul = BigDecimal.ZERO;
                                if (i + 1 == matchCodes.size()) {
                                    mul = NumberUtil.sub((Number)totalDiffAmount, (Number)tmpDiffAmount);
                                } else {
                                    mul = NumberUtil.mul((Number)div1, (Number)dto.getExpensesAmount()).setScale(2, 4);
                                    tmpDiffAmount = tmpDiffAmount.add(mul);
                                }
                                BigDecimal add = NumberUtil.add((Number)mul, (Number)check.getCostDeductionAmount());
                                BigDecimal totalSharePreAuditAmount1 = BigDecimal.ZERO;
                                for (int j = 0; j < auditFeeCheckDetailPlanVos.size(); ++j) {
                                    AuditFeeCheckDetailPlanVo detailPlan = auditFeeCheckDetailPlanVos.get(j);
                                    if (j + 1 == auditFeeCheckDetailPlanVos.size()) {
                                        detailPlan.setAuditFeeCheckShareAmount(NumberUtil.sub((Number)add, (Number)tmpAmount));
                                    } else {
                                        BigDecimal scale = NumberUtil.div((Number)add, (Number)auditFeeCheckDetailPlanVos.size()).setScale(2, 4);
                                        tmpAmount = tmpAmount.add(scale);
                                        detailPlan.setAuditFeeCheckShareAmount(scale);
                                    }
                                    totalSharePreAuditAmount1 = totalSharePreAuditAmount1.add(detailPlan.getAuditFeeCheckShareAmount());
                                }
                                updateAuditFeeCheckDetailPlans.addAll(auditFeeCheckDetailPlanVos);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u677f\u7c7b\u578b");
                            }
                        }
                        updateAuditFeeChecks.add(check);
                    }
                }
            }
        });
        this.auditFeeCheckVoService.saveExpensesDeductResult(updateAuditFeeChecks, updateAuditFeeCheckDetailPlans);
    }

    public BigDecimal calculateDiffAmount(AuditPlanCheckAccount account, List<AuditPlanCheckAccountDetailVo> accountDetailList, BigDecimal totalPreAuditAmount, Map<String, List<AuditFeeCheckVo>> auditFeeCheckVoMap) {
        BigDecimal totalDiffAmount = BigDecimal.ZERO;
        for (AuditPlanCheckAccountDetailVo detail : accountDetailList) {
            if (CollectionUtils.isEmpty(auditFeeCheckVoMap)) continue;
            List<AuditFeeCheckVo> auditFeeCheckVos = auditFeeCheckVoMap.get(detail.getMatchCode());
            block4: for (AuditFeeCheckVo feeCheck : auditFeeCheckVos) {
                DeductionMatchingTemplateTypeEnum templateTypeEnum = DeductionMatchingTemplateTypeEnum.getTypeByCode((String)feeCheck.getMatchTemplateType());
                switch (templateTypeEnum) {
                    case DETAIL_FEE_SETATEMENT: {
                        totalDiffAmount = totalDiffAmount.add(feeCheck.getCostDeductionAmount());
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("\u672a\u77e5\u7684\u6a21\u677f\u7c7b\u578b");
            }
        }
        return NumberUtil.sub((Number)totalDiffAmount, (Number)totalPreAuditAmount);
    }

    public void extractData() {
        AuditFeeCheckDto selectDto = new AuditFeeCheckDto();
        selectDto.setMatchStatus(MatchStatusEnum.MATCHED.getCode());
        selectDto.setIsConfirm(BooleanEnum.TRUE.getCapital());
        selectDto.setTenantCode(TenantUtils.getTenantCode());
        selectDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        List auditFeeCheckVoList = this.auditFeeCheckVoService.getPlanCheckAccountData(selectDto);
        List templateCodes = auditFeeCheckVoList.stream().map(AuditFeeCheckVo::getMatchTemplateCode).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        List templateList = this.tpmDeductionMatchingTemplateService.findByCodes(templateCodes);
        if (CollectionUtils.isEmpty((Collection)templateList)) {
            return;
        }
        HashMap dimensionMap = new HashMap(7);
        templateList.forEach(template -> {
            String matchingCondition = template.getFeeMatchingCondition();
            if (StringUtils.isBlank((CharSequence)matchingCondition)) {
                dimensionMap.put(template.getCode(), "no");
                return;
            }
            Object[] split = matchingCondition.split(",");
            ArrayList matchingConditions = Lists.newArrayList((Object[])split);
            if (matchingConditions.contains(MatchingConditionEnum.PRODUCT_CODE.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH_DAY.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH.getCode())) {
                dimensionMap.put(template.getCode(), "all");
                return;
            }
            if (matchingConditions.contains(MatchingConditionEnum.PRODUCT_CODE.getCode()) && !matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH_DAY.getCode()) && !matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH.getCode())) {
                dimensionMap.put(template.getCode(), "pro");
                return;
            }
            if (matchingConditions.contains(MatchingConditionEnum.PRODUCT_CODE.getCode()) && !matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH_DAY.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH.getCode())) {
                dimensionMap.put(template.getCode(), "proAndDate");
                return;
            }
            if (matchingConditions.contains(MatchingConditionEnum.PRODUCT_CODE.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH_DAY.getCode()) && !matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH.getCode())) {
                dimensionMap.put(template.getCode(), "proAndMonth");
                return;
            }
            if (!matchingConditions.contains(MatchingConditionEnum.PRODUCT_CODE.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH_DAY.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH.getCode())) {
                dimensionMap.put(template.getCode(), "dateAndMonth");
                return;
            }
            if (!matchingConditions.contains(MatchingConditionEnum.PRODUCT_CODE.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH_DAY.getCode()) && !matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH.getCode())) {
                dimensionMap.put(template.getCode(), "date");
                return;
            }
            if (!matchingConditions.contains(MatchingConditionEnum.PRODUCT_CODE.getCode()) && !matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH_DAY.getCode()) && matchingConditions.contains(MatchingConditionEnum.YEAR_MONTH.getCode())) {
                dimensionMap.put(template.getCode(), "month");
                return;
            }
        });
        Map<String, List<AuditFeeCheckVo>> auditFeeCheckVoMap = auditFeeCheckVoList.stream().collect(Collectors.groupingBy(AuditFeeCheckVo::getMatchTemplateCode));
        ArrayList<AuditPlanCheckAccountDto> planCheckAccountList = new ArrayList<AuditPlanCheckAccountDto>();
        for (String key : auditFeeCheckVoMap.keySet()) {
            Map<String, List<AuditFeeCheckVo>> collect;
            List<AuditPlanCheckAccountDto> accountList;
            String dimension = (String)dimensionMap.get(key);
            List<AuditFeeCheckVo> auditFeeCheckVos = auditFeeCheckVoMap.get(key);
            if ("no".equals(dimension) && !CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode())), dimension))) {
                planCheckAccountList.addAll(accountList);
            }
            if ("all".equals(dimension) && !CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode() + k.getProductCode() + k.getOrderYearMonth() + k.getOrderDate())), dimension))) {
                planCheckAccountList.addAll(accountList);
            }
            if ("pro".equals(dimension) && !CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode() + k.getProductCode())), dimension))) {
                planCheckAccountList.addAll(accountList);
            }
            if ("proAndDate".equals(dimension) && !CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode() + k.getProductCode() + k.getOrderDate())), dimension))) {
                planCheckAccountList.addAll(accountList);
            }
            if ("proAndMonth".equals(dimension) && !CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode() + k.getProductCode() + k.getOrderYearMonth())), dimension))) {
                planCheckAccountList.addAll(accountList);
            }
            if ("dateAndMonth".equals(dimension) && !CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode() + k.getOrderYearMonth() + k.getOrderDate())), dimension))) {
                planCheckAccountList.addAll(accountList);
            }
            if ("date".equals(dimension) && !CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode() + k.getOrderDate())), dimension))) {
                planCheckAccountList.addAll(accountList);
            }
            if (!"month".equals(dimension) || CollectionUtils.isEmpty(accountList = this.gatherAccount(collect = auditFeeCheckVos.stream().collect(Collectors.groupingBy(k -> k.getBusinessFormatCode() + k.getBusinessUnitCode() + k.getSalesOrgCode() + k.getMappingCode() + k.getAreaCode() + k.getCustomerErpCode() + k.getCustomerRetailerCode() + k.getOrderYearMonth())), dimension))) continue;
            planCheckAccountList.addAll(accountList);
        }
        this.saveAccounts(planCheckAccountList);
    }

    private List<AuditPlanCheckAccountDto> gatherAccount(Map<String, List<AuditFeeCheckVo>> map, String dimension) {
        if (CollectionUtils.isEmpty(map) || StringUtils.isBlank((CharSequence)dimension)) {
            return null;
        }
        ArrayList<AuditPlanCheckAccountDto> list = new ArrayList<AuditPlanCheckAccountDto>();
        map.keySet().forEach(key -> {
            List auditFeeCheckVos = (List)map.get(key);
            if (CollectionUtils.isEmpty((Collection)auditFeeCheckVos)) {
                return;
            }
            AuditFeeCheckVo feeCheck = (AuditFeeCheckVo)auditFeeCheckVos.get(0);
            AuditPlanCheckAccountDto account = new AuditPlanCheckAccountDto();
            account.setBusinessFormatCode(feeCheck.getBusinessFormatCode());
            account.setBusinessUnitCode(feeCheck.getBusinessUnitCode());
            account.setSalesOrgCode(feeCheck.getSalesOrgCode());
            account.setSalesOrgName(feeCheck.getSalesOrgName());
            account.setMappingCode(feeCheck.getMappingCode());
            account.setCustomerErpCode(feeCheck.getCustomerErpCode());
            account.setBusinessArea(feeCheck.getAreaCode());
            account.setCustomerRetailerCode(feeCheck.getCustomerRetailerCode());
            account.setCustomerRetailerName(feeCheck.getCustomerRetailerName());
            account.setTenantCode(TenantUtils.getTenantCode());
            account.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            BigDecimal totalCost = BigDecimal.ZERO;
            BigDecimal advanceEndCostAmount = BigDecimal.ZERO;
            BigDecimal costAmount = BigDecimal.ZERO;
            BigDecimal statementAmount = BigDecimal.ZERO;
            ArrayList<AuditPlanCheckAccountDetailDto> detailList = new ArrayList<AuditPlanCheckAccountDetailDto>();
            for (AuditFeeCheckVo auditFeeCheckVo : auditFeeCheckVos) {
                AuditPlanCheckAccountDetailDto detail = new AuditPlanCheckAccountDetailDto();
                detail.setMatchCode(feeCheck.getMatchCode());
                detailList.add(detail);
                BigDecimal total = auditFeeCheckVo.getAuditFeeCheckDetailPlans().stream().map(AuditFeeCheckDetailPlanVo::getApplyAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalCost = totalCost.add(total);
                BigDecimal advanceEndCost = auditFeeCheckVo.getAuditFeeCheckDetailPlans().stream().map(AuditFeeCheckDetailPlanVo::getPredictionAuditAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                advanceEndCostAmount = advanceEndCostAmount.add(advanceEndCost);
                BigDecimal costDeductionTax = auditFeeCheckVo.getCosts().stream().map(AuditFeeCheckCostVo::getDeductionAmountTax).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                costAmount = costAmount.add(costDeductionTax);
            }
            account.setMatchedCodeList(detailList);
            account.setApplyAmount(totalCost);
            account.setAdvanceEndCostAmount(advanceEndCostAmount);
            account.setCostAmount(costAmount);
            account.setStatementAmount(statementAmount);
            account.setCostDetailDiffAmount(costAmount.subtract(advanceEndCostAmount));
            account.setSettlementDetailDiffAmount(statementAmount.subtract(advanceEndCostAmount));
            if ("all".equals(dimension)) {
                account.setProductCode(feeCheck.getProductCode());
                account.setAccountDate(feeCheck.getOrderDate());
                account.setFeeYearMonth(DateUtil.format((Date)feeCheck.getOrderYearMonth(), (String)"yyyy-MM"));
            }
            if ("pro".equals(dimension)) {
                account.setProductCode(feeCheck.getProductCode());
            }
            if ("proAndDate".equals(dimension)) {
                account.setProductCode(feeCheck.getProductCode());
                account.setAccountDate(feeCheck.getOrderDate());
            }
            if ("proAndMonth".equals(dimension)) {
                account.setProductCode(feeCheck.getProductCode());
                account.setFeeYearMonth(DateUtil.format((Date)feeCheck.getOrderYearMonth(), (String)"yyyy-MM"));
            }
            if ("dateAndMonth".equals(dimension)) {
                account.setAccountDate(feeCheck.getOrderDate());
                account.setFeeYearMonth(DateUtil.format((Date)feeCheck.getOrderYearMonth(), (String)"yyyy-MM"));
            }
            if ("date".equals(dimension)) {
                account.setAccountDate(feeCheck.getOrderDate());
            }
            if ("month".equals(dimension)) {
                account.setFeeYearMonth(DateUtil.format((Date)feeCheck.getOrderYearMonth(), (String)"yyyy-MM"));
            }
            list.add(account);
        });
        return list;
    }

    public void confirm(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u63d0\u4ea4\u786e\u8ba4\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<AuditPlanCheckAccount> accountList = this.auditPlanCheckAccountRepository.getByIds(ids);
        List confirmList = accountList.stream().filter(x -> StringUtils.equals((CharSequence)BooleanEnum.TRUE.getCapital(), (CharSequence)x.getIsConfirm())).collect(Collectors.toList());
        Validate.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(confirmList), (String)"\u5b58\u5728\u5df2\u786e\u8ba4\u6570\u636e,\u8bf7\u68c0\u67e5!!!", (Object[])new Object[0]);
        Date now = new Date();
        AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
        accountList.forEach(account -> {
            account.setIsConfirm(BooleanEnum.TRUE.getCapital());
            account.setConfirmDate(now);
            account.setConfirmUserAccount(loginUser.getAccount());
            account.setConfirmUserName(loginUser.getUsername());
        });
        this.auditPlanCheckAccountRepository.updateBatchById(accountList);
    }

    public List<AuditPlanCheckAccountDetailVo> findRelateMatchCode(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Lists.newArrayList();
        }
        AuditPlanCheckAccount account = (AuditPlanCheckAccount)((Object)this.auditPlanCheckAccountRepository.getById((Serializable)((Object)id)));
        Validate.notNull((Object)((Object)account), (String)"\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u6570\u636e\uff01", (Object[])new Object[0]);
        List<AuditPlanCheckAccountDetailVo> detailList = this.auditPlanCheckAccountDetailService.findByAccountCode(account.getAccountCode());
        if (CollectionUtils.isEmpty(detailList)) {
            return Lists.newArrayList();
        }
        return detailList;
    }
}

