package com.biz.crm.tpm.business.budget.cal.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 15:25
 */
@RestController
@RequestMapping("/v1/budget/cal/config")
@Slf4j
@Api(tags = "预算计算配置")
public class BudgetCalConfigController {

    @Autowired(required = false)
    private BudgetCalConfigService budgetCalConfigService;

    /**
     * 分页查询所有数据
     *
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<BudgetCalConfigVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                            @ApiParam(name = "budgetCalConfigDto", value = "预算计算配置") BudgetCalConfigDto dto) {
        try {
            Page<BudgetCalConfigVo> page = this.budgetCalConfigService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @ApiOperation(value = "通过主键查询单条数据")
    @GetMapping("detail")
    public Result<BudgetCalConfigVo> detail(@RequestParam("id") @ApiParam(name = "id", value = "主键id") String id) {
        try {
            BudgetCalConfigVo budgetCalConfigVo = this.budgetCalConfigService.findById(id);
            return Result.ok(budgetCalConfigVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 条件查询所有数据
     *
     * @param dto 查询实体
     * @return 条件查询所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @PostMapping("listByConditions")
    public Result<List<BudgetCalConfigVo>> listByConditions(@RequestBody BudgetCalConfigDto dto) {
        try {
            List<BudgetCalConfigVo> result = this.budgetCalConfigService.listByConditions(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 新增数据
     *
     * @param dto 实体对象
     * @return 新增结果
     */
    @ApiOperation(value = "新增数据")
    @PostMapping
    public Result<BudgetCalConfigVo> create(@ApiParam(name = "budgetItemDto", value = "TPM-预算计算配置") @RequestBody BudgetCalConfigDto dto) {
        try {
            BudgetCalConfigVo result = this.budgetCalConfigService.create(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 修改数据
     *
     * @param dto 实体对象
     * @return 修改结果
     */
    @ApiOperation(value = "修改数据")
    @PatchMapping
    public Result<BudgetCalConfigVo> update(@ApiParam(name = "budgetItemDto", value = "TPM-预算计算配置") @RequestBody BudgetCalConfigDto dto) {
        try {
            BudgetCalConfigVo result = this.budgetCalConfigService.update(dto);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    @DeleteMapping
    @ApiOperation(value = "删除数据")
    public Result<?> delete(@RequestParam("ids") List<String> ids) {
        try {
            this.budgetCalConfigService.delete(ids);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量根据id启用
     */
    @ApiOperation(value = "批量根据id启用")
    @PatchMapping(value = "enable")
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.budgetCalConfigService.enable(ids);
            return Result.ok("启用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 批量根据id禁用
     */
    @ApiOperation(value = "批量根据id禁用")
    @PatchMapping(value = "disable")
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.budgetCalConfigService.disable(ids);
            return Result.ok("禁用成功");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据预算类型查询计算配置的数据来源
     */
    @ApiOperation(value = "根据预算类型查询计算配置的数据来源")
    @GetMapping(value = "listSelectByBudget")
    public Result<List<CommonSelectVo>> listSelectByBudget(@RequestParam(value = "budgetType", required = false) String budgetType) {
        try {
            List<CommonSelectVo> commonSelectVoList = this.budgetCalConfigService.listSelect(BooleanEnum.TRUE.getCapital(), budgetType);
            return Result.ok(commonSelectVoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 根据数据来源查询计算配置的数据来源
     */
    @ApiOperation(value = "根据数据来源查询计算配置的数据来源")
    @GetMapping(value = "listSelectByDataFrom")
    public Result<List<CommonSelectVo>> listSelectByDataFrom(@RequestParam(value = "dataFrom", required = false) String dataFrom) {
        try {
            List<CommonSelectVo> commonSelectVoList = this.budgetCalConfigService.listSelect(BooleanEnum.FALSE.getCapital(), dataFrom);
            return Result.ok(commonSelectVoList);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
