package com.biz.crm.tpm.business.budget.cal.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author huojia
 * @date 2022年11月02日 15:07
 */
@ApiModel(value = "BudgetCalConfigAreaEntity", description = "TPM-预算计算配置范围")
@TableName("tpm_budget_cal_config_area")
@Getter
@Setter
@Entity(name = "tpm_budget_cal_config_area")
@Table(name = "tpm_budget_cal_config_area", indexes = {
        @Index(name = "tpm_budget_cal_config_area_index1", columnList = "budget_cal_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_cal_config_area", comment = "TPM-预算计算配置范围")
public class BudgetCalConfigAreaEntity extends TenantFlagOpEntity {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(name = "预算计算编码", notes = "")
    @Column(name = "budget_cal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '预算计算编码 '")
    private String budgetCalCode;

    /**
     * 范围类型编码[数据字典:tpm_cal_area_type]
     */
    @ApiModelProperty(name = "范围类型编码[数据字典:tpm_cal_area_type]", notes = "")
    @Column(name = "area_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '范围类型编码[数据字典:tpm_cal_area_type] '")
    private String areaTypeCode;

    /**
     * 数据编码
     */
    @ApiModelProperty(name = "数据编码", notes = "")
    @Column(name = "data_code", nullable = false, length = 32, columnDefinition = "VARCHAR(64) COMMENT '数据编码 '")
    private String dataCode;

    /**
     * 数据名称
     */
    @ApiModelProperty(name = "数据名称", notes = "")
    @Column(name = "data_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '数据名称 '")
    private String dataName;

    /**
     * 客户类型[数据字典:mdm_customer_type]
     */
    @ApiModelProperty(name = "客户类型[数据字典:mdm_customer_type]", notes = "")
    @Column(name = "customer_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户类型[数据字典:mdm_customer_type] '")
    private String customerTypeCode;

    /**
     * 客户级别
     */
    @ApiModelProperty(name = "客户级别", notes = "")
    @Column(name = "customer_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户级别 '")
    private String customerLevelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(name = "客户渠道编码", notes = "")
    @Column(name = "customer_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户渠道编码 '")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(name = "客户渠道名称", notes = "")
    @Column(name = "customer_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户渠道名称 '")
    private String customerChannelName;

    /**
     * 一级渠道编码
     */
    @ApiModelProperty(name = "一级渠道编码", notes = "")
    @Column(name = "first_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '一级渠道编码 '")
    private String firstChannelCode;

    /**
     * 一级渠道名称
     */
    @ApiModelProperty(name = "一级渠道名称", notes = "")
    @Column(name = "first_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '一级渠道名称 '")
    private String firstChannelName;

    /**
     * 二级渠道编码
     */
    @ApiModelProperty(name = "二级渠道编码", notes = "")
    @Column(name = "second_channel_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '二级渠道编码 '")
    private String secondChannelCode;

    /**
     * 二级渠道名称
     */
    @ApiModelProperty(name = "二级渠道名称", notes = "")
    @Column(name = "second_channel_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '二级渠道名称 '")
    private String secondChannelName;

    /**
     * 上级客户/分销商编码
     */
    @ApiModelProperty(name = "上级客户/分销商编码", notes = "")
    @Column(name = "parent_customer_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '上级客户/分销商编码 '")
    private String parentCustomerCode;

    /**
     * 上级客户/分销商名称
     */
    @ApiModelProperty(name = "上级客户/分销商名称", notes = "")
    @Column(name = "parent_customer_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '上级客户/分销商名称 '")
    private String parentCustomerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(name = "品牌编码", notes = "")
    @Column(name = "product_brand_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(name = "品牌名称", notes = "")
    @Column(name = "product_brand_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(name = "品类编码", notes = "")
    @Column(name = "product_category_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(name = "品类名称", notes = "")
    @Column(name = "product_category_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(name = "品项编码", notes = "")
    @Column(name = "product_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品项编码 '")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(name = "品项名称", notes = "")
    @Column(name = "product_item_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品项名称 '")
    private String productItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(name = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    @Column(name = "budget_item_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算项目层级[数据字典:tpm_budget_item_level] '")
    private String budgetItemLevelCode;

    /**
     * 上级预算项目编码
     */
    @ApiModelProperty(name = "上级预算项目编码", notes = "")
    @Column(name = "parent_budget_item_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '上级预算项目编码 '")
    private String parentBudgetItemCode;

    /**
     * 上级预算项目名称
     */
    @ApiModelProperty(name = "上级预算项目名称", notes = "")
    @Column(name = "parent_budget_item_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '上级预算项目名称 '")
    private String parentBudgetItemName;

    /**
     * 费用属性[数据字典:tpm_budget_fee_attr]
     */
    @ApiModelProperty(name = "费用属性[数据字典:tpm_budget_fee_attr]", notes = "")
    @Column(name = "fee_attr_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用属性[数据字典:tpm_budget_fee_attr] '")
    private String feeAttrCode;

    /**
     * 指定剔除年月
     */
    @ApiModelProperty(value = "指定剔除年月yyyy-MM")
    @Column(name = "fil_year_month", nullable = true, length = 10, columnDefinition = "VARCHAR(10) COMMENT '指定剔除年月yyyy-MM'")
    private String filYearMonth;
}
