package com.biz.crm.tpm.business.budget.cal.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author huojia
 * @date 2022年11月02日 15:07
 */
@ApiModel(value = "BudgetCalConfigDataEntity", description = "TPM-预算计算配置数据配置")
@TableName("tpm_budget_cal_config_data")
@Getter
@Setter
@Entity(name = "tpm_budget_cal_config_data")
@Table(name = "tpm_budget_cal_config_data", indexes = {
        @Index(name = "tpm_budget_cal_config_data_index1", columnList = "budget_cal_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_cal_config_data", comment = "TPM-预算计算配置数据配置")
public class BudgetCalConfigDataEntity extends TenantFlagOpEntity {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(name = "预算计算编码", notes = "")
    @Column(name = "budget_cal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算计算编码 '")
    private String budgetCalCode;

    /**
     * 数据配置来源编码[数据字典:tpm_cal_data_from]
     */
    @ApiModelProperty(name = "数据配置来源编码[数据字典:tpm_cal_data_from]", notes = "")
    @Column(name = "cal_data_from_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '数据配置来源编码[数据字典:tpm_cal_data_from] '")
    private String calDataFromCode;

    /**
     * 金额类型[数据字典:tpm_amount_type]
     */
    @ApiModelProperty(name = "金额类型[数据字典:tpm_amount_type]", notes = "")
    @Column(name = "amount_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '金额类型[数据字典:tpm_amount_type] '")
    private String amountTypeCode;

    /**
     * 客户类型[数据字典:mdm_customer_type]
     */
    @ApiModelProperty(name = "客户类型[数据字典:mdm_customer_type]", notes = "")
    @Column(name = "customer_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户类型[数据字典:mdm_customer_type] '")
    private String customerTypeCode;
}
