package com.biz.crm.tpm.business.budget.cal.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.util.Date;

/**
 * @author huojia
 * @date 2022年11月02日 14:58
 */
@ApiModel(value = "BudgetCalConfigEntity", description = "TPM-预算计算配置")
@TableName("tpm_budget_cal_config")
@Getter
@Setter
@Entity(name = "tpm_budget_cal_config")
@Table(name = "tpm_budget_cal_config", indexes = {
        @Index(name = "tpm_budget_cal_config_index1", columnList = "budget_cal_code", unique = true),
        @Index(name = "tpm_budget_cal_config_index2", columnList = "fee_belong_code", unique = false),
        @Index(name = "tpm_budget_cal_config_index3", columnList = "org_area_code", unique = false),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_cal_config", comment = "TPM-预算计算配置")
public class BudgetCalConfigEntity extends TenantFlagOpEntity {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(name = "预算计算编码", notes = "")
    @Column(name = "budget_cal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算计算编码 '")
    private String budgetCalCode;

    /**
     * 预算计算名称
     */
    @ApiModelProperty(name = "预算计算名称", notes = "")
    @Column(name = "budget_cal_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '预算计算名称 '")
    private String budgetCalName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(name = "业态[数据字典:mdm_business_format]", notes = "")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态[数据字典:mdm_business_format] '")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(name = "业务单元[数据字典:mdm_business_unit]", notes = "")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元[数据字典:mdm_business_unit] '")
    private String businessUnitCode;

    /**
     * 预算类型[数据字典:tpm_budget_type]
     */
    @ApiModelProperty(name = "预算类型[数据字典:tpm_budget_type]", notes = "")
    @Column(name = "budget_type_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算类型[数据字典:tpm_budget_type] '")
    private String budgetTypeCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(name = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    /**
     * 销售组织范围[数据字典:tpm_org_area]
     */
    @ApiModelProperty(name = "销售组织范围[数据字典:tpm_org_area]", notes = "销售组织范围[数据字典:tpm_org_area]")
    @Column(name = "org_area_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织范围[数据字典:tpm_org_area] '")
    private String orgAreaCode;

    /**
     * 生效起始时间
     */
    @ApiModelProperty("生效起始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "effect_begin_time", length = 32, columnDefinition = "datetime COMMENT '生效起始时间'")
    private Date effectBeginTime;

    /**
     * 生效结束时间
     */
    @ApiModelProperty("生效结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "effect_end_time", length = 32, columnDefinition = "datetime COMMENT '生效结束时间'")
    private Date effectEndTime;

    /**
     * 管控类型
     */
    @ApiModelProperty(value = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    @Column(name = "control_type", length = 64, columnDefinition = "varchar(64) COMMENT '管控类型'")
    private String controlType;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    @Column(name = "group_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '分组[数据字典:tpm_group_code] '")
    private String groupCode;
}
