package com.biz.crm.tpm.business.budget.cal.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * TPM-预算计算配置产品计费比例
 *
 * @author : rentao
 * @date : 2023/2/1 18:26
 */
@ApiModel(value = "BudgetCalConfigProductRatioEntity", description = "TPM-预算计算配置产品计费比例")
@TableName("tpm_budget_cal_config_product_ratio")
@Getter
@Setter
@Entity(name = "tpm_budget_cal_config_product_ratio")
@Table(name = "tpm_budget_cal_config_product_ratio", indexes = {
        @Index(name = "tpm_budget_cal_config_product_ratio_index1", columnList = "budget_cal_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_cal_config_product_ratio", comment = "TPM-预算计算配置包含销售组织")
public class BudgetCalConfigProductRatioEntity extends TenantFlagOpEntity {

  /**
   * 预算计算编码
   */
  @ApiModelProperty(name = "预算计算编码", notes = "")
  @Column(name = "budget_cal_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算计算编码 '")
  private String budgetCalCode;

  /**
   * 产品编码
   */
  @ApiModelProperty(name = "产品编码", notes = "产品编码")
  @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
  private String productCode;

  /**
   * 产品名称
   */
  @ApiModelProperty(name = "产品名称", notes = "产品名称")
  @Column(name = "product_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品名称'")
  private String productName;
  /**
   * 产品品牌编码
   */
  @ApiModelProperty(name = "产品品牌编码", notes = "产品品牌编码")
  @Column(name = "product_brand_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品品牌编码 '")
  private String productBrandCode;
  /**
   * 产品品牌名称
   */
  @ApiModelProperty(name = "产品品牌名称", notes = "产品品牌名称")
  @Column(name = "product_brand_name", length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品品牌名称 '")
  private String productBrandName;
  /**
   * 所属产品品类编码
   */
  @ApiModelProperty("所属产品品类编码")
  @Column(name = "product_category_code", length = 64, columnDefinition = "varchar(64) COMMENT '所属产品品类编码'")
  private String productCategoryCode;
  /**
   * 所属产品品类名称
   */
  @ApiModelProperty(name = "所属产品品类名称", notes = "所属产品品类名称")
  @Column(name = "product_category_name", length = 64, columnDefinition = "varchar(64) COMMENT '所属产品品类名称'")
  private String productCategoryName;
  /**
   * 产品品项编码
   */
  @ApiModelProperty("产品品项编码")
  @Column(name = "product_item_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品品项编码'")
  private String productItemCode;
  /**
   * 产品品项名称
   */
  @ApiModelProperty(name = "产品品项名称", notes = "产品品项名称")
  @Column(name = "product_item_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品品项名称'")
  private String productItemName;

  /**
   * 计费点数
   */
  @ApiModelProperty(name = "计费点数", notes = "计费点数")
  @Column(name = "charged_ratio", nullable = false, length = 20, columnDefinition = "DECIMAL(20,4) COMMENT '计费点数 '")
  private BigDecimal chargedRatio;

  /**
   * 是否扣减
   */
  @ApiModelProperty(name = "是否扣减", notes = "是否扣减")
  @Column(name = "reduce_tag", nullable = false, length = 2, columnDefinition = "varchar(2) COMMENT '是否扣减 '")
  private String reduceTag;
}
