package com.biz.crm.tpm.business.budget.cal.config.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author huojia
 * @date 2022年11月15日 10:21
 */
@ApiModel(value = "BudgetCalConfigSalesOrgEntity", description = "TPM-预算计算配置")
@TableName("tpm_budget_cal_config_sales_org")
@Getter
@Setter
@Entity(name = "tpm_budget_cal_config_sales_org")
@Table(name = "tpm_budget_cal_config_sales_org", indexes = {
        @Index(name = "tpm_budget_cal_config_sales_org_index1", columnList = "budget_cal_code"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_cal_config_sales_org", comment = "TPM-预算计算配置包含销售组织")
public class BudgetCalConfigSalesOrgEntity extends TenantFlagOpEntity {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(name = "预算计算编码", notes = "")
    @Column(name = "budget_cal_code", nullable = true, length = 32, columnDefinition = "VARCHAR(64) COMMENT '预算计算编码 '")
    private String budgetCalCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(name = "销售组织编码", notes = "销售组织编码")
    @Column(name = "sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织编码 '")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(name = "销售组织名称", notes = "销售组织名称")
    @Column(name = "sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称 '")
    private String salesOrgName;

    /**
     * 销售组织层级
     */
    @ApiModelProperty(name = "销售组织层级", notes = "销售组织层级")
    @Column(name = "sales_level_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织层级 '")
    private String salesLevelCode;

    /**
     * 上级销售组织编码
     */
    @ApiModelProperty(name = "上级销售组织编码", notes = "上级销售组织编码")
    @Column(name = "parent_sales_org_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '上级销售组织编码 '")
    private String parentSalesOrgCode;

    /**
     * 上级销售组织名称
     */
    @ApiModelProperty(name = "上级销售组织名称", notes = "上级销售组织名称")
    @Column(name = "parent_sales_org_name", nullable = true, length = 256, columnDefinition = "VARCHAR(256) COMMENT '上级销售组织名称 '")
    private String parentSalesOrgName;
}
