package com.biz.crm.tpm.business.budget.cal.config.local.entity;

/**
 * @author : rentao
 * @date : 2023/2/1 18:36
 */

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * TPM-预算计算配置预算范围产品
 *
 * @author : rentao
 * @date : 2023/2/1 18:26
 */
@ApiModel(value = "BudgetCalConfigScopeProductEntity", description = "TPM-预算计算配置预算范围产品")
@TableName("tpm_budget_cal_config_scope_product")
@Getter
@Setter
@Entity(name = "tpm_budget_cal_config_scope_product")
@Table(name = "tpm_budget_cal_config_scope_product", indexes = {
        @Index(name = "tpm_budget_cal_config_scope_product_index1", columnList = "budget_cal_code"),
        @Index(name = "tpm_budget_cal_config_scope_product_index2", columnList = "config_area_id"),
})
@org.hibernate.annotations.Table(appliesTo = "tpm_budget_cal_config_scope_product", comment = "TPM-预算计算配置预算范围产品")
public class BudgetCalConfigScopeProductEntity extends TenantFlagOpEntity {

  /**
   * 预算计算编码
   */
  @ApiModelProperty(name = "预算计算编码", notes = "")
  @Column(name = "budget_cal_code", nullable = false, length = 32, columnDefinition = "VARCHAR(32) COMMENT '预算计算编码 '")
  private String budgetCalCode;

  /**
   * 产品编码
   */
  @ApiModelProperty(name = "产品编码", notes = "产品编码")
  @Column(name = "product_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品编码'")
  private String productCode;

  /**
   * 产品名称
   */
  @ApiModelProperty(name = "产品名称", notes = "产品名称")
  @Column(name = "product_name", length = 64, columnDefinition = "varchar(64) COMMENT '产品名称'")
  private String productName;

  /**
   * 范围id
   */
  @ApiModelProperty(name = "范围id", notes = "范围id")
  @Column(name = "config_area_id", length = 36, columnDefinition = "varchar(36) COMMENT '范围id'")
  private String configAreaId;

}
