package com.biz.crm.tpm.business.budget.cal.config.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 * @author huojia
 * @date 2022年11月07日 17:10
 */
@Component
public class BudgetCalConfigRegister implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_budget_cal_config_data_view";
    }

    @Override
    public String desc() {
        return "TPM-预算计算配置";
    }

    @Override
    public String buildSql() {
        return " select a.*,DATE_FORMAT(a.effect_begin_time,'%Y-%m-%d') AS effect_begin_time_str,DATE_FORMAT(a.effect_end_time,'%Y-%m-%d') AS effect_end_time_str " +
                "from tpm_budget_cal_config a " +
                "where a.tenant_code = :tenantCode " +
                "and a.del_flag = '" + DelFlagStatusEnum.NORMAL.getCode() + "' ";
    }
}
