package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigAreaEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigAreaMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalAreaTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 23:17
 */
@Component
public class BudgetCalConfigAreaRepository extends ServiceImpl<BudgetCalConfigAreaMapper, BudgetCalConfigAreaEntity> {

    /**
     * 根据计算配置编码查询
     *
     * @param budgetCalCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigAreaEntity>
     * @author huojia
     * @date 2022/11/2 23:28
     **/
    public List<BudgetCalConfigAreaEntity> listByCalConfigCode(String budgetCalCode) {
        if (StringUtils.isEmpty(budgetCalCode)) {
            return Arrays.asList();
        }
        return this.lambdaQuery()
                .eq(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据预算计算配置编码逻辑范围
     *
     * @param budgetCalCode
     * @author huojia
     * @date 2022/11/3 11:26
     **/
    public void delByBudgetCalCode(String budgetCalCode) {
        if (StringUtils.isEmpty(budgetCalCode)) {
            return;
        }
        List<BudgetCalConfigAreaEntity> list = this.lambdaQuery().eq(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCode).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetCalConfigAreaEntity -> {
                budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 批量逻辑删除
     *
     * @param budgetCalCodeList
     * @author huojia
     * @date 2022/11/3 11:40
     **/
    public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return;
        }
        List<BudgetCalConfigAreaEntity> list = this.lambdaQuery().in(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCodeList).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetCalConfigAreaEntity -> {
                budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 查询预算范围根据预算计算配置编码和预算项目编码
     *
     * @param budgetCalCodeList 预算计算编码列表
     * @param itemCodeList  预算项目编码列表
     * @date 2023/05/16 10:42
     **/
    public Integer listByCalCodesAndItemCodes(List<String> budgetCalCodeList, List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList) || CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(BudgetCalConfigAreaEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(BudgetCalConfigAreaEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(BudgetCalConfigAreaEntity::getAreaTypeCode, CalAreaTypeEnum.BUDGET_ITEM.getCode())
                .in(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCodeList)
                .in(BudgetCalConfigAreaEntity::getDataCode, itemCodeList).count();
    }

    /**
     * 查询预算范围根据预算计算配置编码
     *
     * @param budgetCalCodeList 预算计算编码列表
     * @date 2023/05/16 10:42
     **/
    public List<BudgetCalConfigAreaEntity> listByCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(BudgetCalConfigAreaEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(BudgetCalConfigAreaEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(BudgetCalConfigAreaEntity::getAreaTypeCode, CalAreaTypeEnum.BUDGET_ITEM.getCode())
                .in(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCodeList).list();
    }
}
