package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigDataEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigDataMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDataDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 23:18
 */
@Component
public class BudgetCalConfigDataRepository extends ServiceImpl<BudgetCalConfigDataMapper, BudgetCalConfigDataEntity> {

    /**
     * 根据计算配置编码查询
     *
     * @param budgetCalCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigDataEntity>
     * @author huojia
     * @date 2022/11/2 23:29
     **/
    public List<BudgetCalConfigDataEntity> listByCalConfigCode(String budgetCalCode) {
        if (StringUtils.isEmpty(budgetCalCode)) {
            return Arrays.asList();
        }
        return this.lambdaQuery()
                .eq(BudgetCalConfigDataEntity::getBudgetCalCode, budgetCalCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }

    /**
     * 根据计算配置编码删除数据配置
     *
     * @param budgetCalCode
     * @author huojia
     * @date 2022/11/3 11:28
     **/
    public void delByBudgetCalCode(String budgetCalCode) {
        if (StringUtils.isEmpty(budgetCalCode)) {
            return;
        }
        List<BudgetCalConfigDataEntity> list = this.lambdaQuery().eq(BudgetCalConfigDataEntity::getBudgetCalCode, budgetCalCode).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetCalConfigDataEntity -> {
                budgetCalConfigDataEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 批量逻辑删除
     *
     * @param budgetCalCodeList
     * @author huojia
     * @date 2022/11/3 11:39
     **/
    public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return;
        }
        List<BudgetCalConfigDataEntity> list = this.lambdaQuery().in(BudgetCalConfigDataEntity::getBudgetCalCode, budgetCalCodeList).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetCalConfigDataEntity -> {
                budgetCalConfigDataEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 条件查询
     *
     * @param budgetCalCodeList
     * @param data
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigDataEntity>
     * @author huojia
     * @date 2022/12/24 10:42
     **/
    public List<BudgetCalConfigDataEntity> listByConditions(List<String> budgetCalCodeList, BudgetCalConfigDataDto data) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return null;
        }
        LambdaQueryChainWrapper<BudgetCalConfigDataEntity> eq = this.lambdaQuery().in(BudgetCalConfigDataEntity::getBudgetCalCode, budgetCalCodeList)
                .eq(BudgetCalConfigDataEntity::getCalDataFromCode, data.getCalDataFromCode())
                .eq(BudgetCalConfigDataEntity::getAmountTypeCode, data.getAmountTypeCode())
                .eq(BudgetCalConfigDataEntity::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(BudgetCalConfigDataEntity::getTenantCode, TenantUtils.getTenantCode());
        if (StringUtils.isEmpty(data.getCustomerTypeCode())) {
            return eq.isNull(BudgetCalConfigDataEntity::getCustomerTypeCode).list();
        } else {
            return eq.eq(BudgetCalConfigDataEntity::getCustomerTypeCode, data.getCustomerTypeCode()).list();
        }
    }
}
