package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigDataEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigProductRatioEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigScopeProductEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigProductRatioMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigProductRatioDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 预算计算配置产品计费比例
 *
 * @author : rentao
 * @date : 2023/2/1 18:45
 */
@Component
public class BudgetCalConfigProductRatioRepository extends ServiceImpl<BudgetCalConfigProductRatioMapper, BudgetCalConfigProductRatioEntity> {

  /**
   * 根据计算配置编码查询
   *
   * @param dto
   * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigProductRatioEntity>
   * @author huojia
   * @date 2022/11/2 23:29
   **/
  public List<BudgetCalConfigProductRatioEntity> listByCalConfigCode(BudgetCalConfigProductRatioDto dto) {
    return this.lambdaQuery()
            .eq(BudgetCalConfigProductRatioEntity::getBudgetCalCode, dto.getBudgetCalCode())
            .eq(BudgetCalConfigProductRatioEntity::getTenantCode, TenantUtils.getTenantCode())
            .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .list();
  }

  /**
   * 批量逻辑删除
   *
   * @param budgetCalCodeList
   * @author huojia
   * @date 2022/11/3 11:40
   **/
  public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
    if (CollectionUtils.isEmpty(budgetCalCodeList)) {
      return;
    }
    List<BudgetCalConfigProductRatioEntity> list = this.lambdaQuery().in(BudgetCalConfigProductRatioEntity::getBudgetCalCode, budgetCalCodeList).list();
    if (!CollectionUtils.isEmpty(list)) {
      list.forEach(budgetCalConfigAreaEntity -> {
        budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
      });
      this.updateBatchById(list);
    }
  }
}
