package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 23:12
 */
@Component
public class BudgetCalConfigRepository extends ServiceImpl<BudgetCalConfigMapper, BudgetCalConfigEntity> {

    /**
     * 根据id获取预算配置
     *
     * @param id
     * @param delFlag
     * @return com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigEntity
     * @author huojia
     * @date 2022/11/2 23:16
     **/
    public BudgetCalConfigEntity getById(String id, String delFlag) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        return this.lambdaQuery().eq(BudgetCalConfigEntity::getId, id)
                .eq(StringUtils.isNotEmpty(delFlag), UuidFlagOpEntity::getDelFlag, delFlag)
                .one();
    }

    /**
     * 批量查询
     *
     * @param ids
     * @param delFlag
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigEntity>
     * @author huojia
     * @date 2022/11/3 11:42
     **/
    public List<BudgetCalConfigEntity> listByIds(List<String> ids, String delFlag) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return this.lambdaQuery().in(BudgetCalConfigEntity::getId, ids)
                .eq(StringUtils.isNotEmpty(delFlag), UuidFlagOpEntity::getDelFlag, delFlag)
                .list();
    }

    /**
     * 条件查询
     *
     * @param budgetCalConfigDto
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigEntity>
     * @author huojia
     * @date 2022/11/3 17:19
     **/
    public List<BudgetCalConfigEntity> listByConditions(BudgetCalConfigDto budgetCalConfigDto) {
        return this.lambdaQuery()
                .ne(StringUtils.isNotEmpty(budgetCalConfigDto.getId()), UuidEntity::getId, budgetCalConfigDto.getId())
                .eq(StringUtils.isNotEmpty(budgetCalConfigDto.getBusinessFormatCode()), BudgetCalConfigEntity::getBusinessFormatCode, budgetCalConfigDto.getBusinessFormatCode())
                .eq(StringUtils.isNotEmpty(budgetCalConfigDto.getBusinessUnitCode()), BudgetCalConfigEntity::getBusinessUnitCode, budgetCalConfigDto.getBusinessUnitCode())
                .eq(StringUtils.isNotEmpty(budgetCalConfigDto.getBudgetTypeCode()), BudgetCalConfigEntity::getBudgetTypeCode, budgetCalConfigDto.getBudgetTypeCode())
                .eq(StringUtils.isNotEmpty(budgetCalConfigDto.getFeeBelongCode()), BudgetCalConfigEntity::getFeeBelongCode, budgetCalConfigDto.getFeeBelongCode())
                .eq(StringUtils.isNotEmpty(budgetCalConfigDto.getControlType()), BudgetCalConfigEntity::getControlType, budgetCalConfigDto.getControlType())
                .eq(StringUtils.isNotEmpty(budgetCalConfigDto.getGroupCode()), BudgetCalConfigEntity::getGroupCode, budgetCalConfigDto.getGroupCode())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(StringUtils.isNotEmpty(budgetCalConfigDto.getEnableStatus()), BudgetCalConfigEntity::getEnableStatus, budgetCalConfigDto.getEnableStatus())
                .list();
    }


}
