package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigSalesOrgEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigSalesOrgMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigSalesOrgDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 23:17
 */
@Component
public class BudgetCalConfigSalesOrgRepository extends ServiceImpl<BudgetCalConfigSalesOrgMapper, BudgetCalConfigSalesOrgEntity> {

    /**
     * 删除包含销售组织
     *
     * @param budgetCalCode
     * @author huojia
     * @date 2022/11/15 11:08
     **/
    public void delByBudgetCalCode(String budgetCalCode) {
        if (StringUtils.isEmpty(budgetCalCode)) {
            return;
        }
        List<BudgetCalConfigSalesOrgEntity> list = this.lambdaQuery().eq(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCode).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetCalConfigSalesOrgEntity -> {
                budgetCalConfigSalesOrgEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 批量删除包含销售组织
     *
     * @param budgetCalCodeList
     * @author huojia
     * @date 2022/11/15 11:11
     **/
    public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return;
        }
        List<BudgetCalConfigSalesOrgEntity> list = this.lambdaQuery().in(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCodeList).list();
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(budgetCalConfigSalesOrgEntity -> {
                budgetCalConfigSalesOrgEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            });
            this.updateBatchById(list);
        }
    }

    /**
     * 根据计算配置编码查询
     *
     * @param budgetCalCode
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigSalesOrgEntity>
     * @author huojia
     * @date 2022/11/15 11:16
     **/
    public List<BudgetCalConfigSalesOrgEntity> listByCalConfigCode(String budgetCalCode) {
        if (StringUtils.isEmpty(budgetCalCode)) {
            return Lists.newArrayList();
        }
        return this.lambdaQuery()
                .eq(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCode)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }


    /**
     * 条件查询
     *
     * @param budgetCalCodeList 预算计算编码列表
     * @param data              TPM-预算计算配置包含销售组织
     * @date 2022/12/24 10:42
     **/
    public List<BudgetCalConfigSalesOrgEntity> listByConditions(List<String> budgetCalCodeList, BudgetCalConfigSalesOrgDto data) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return null;
        }
        LambdaQueryChainWrapper<BudgetCalConfigSalesOrgEntity> eq = this.lambdaQuery().in(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCodeList)
                .eq(BudgetCalConfigSalesOrgEntity::getSalesOrgCode, data.getSalesOrgCode());
        return eq.list();
    }

    /**
     * 查询范围配置根据预算计算配置编码和范围编码
     *
     * @param budgetCalCodeList 预算计算编码列表
     * @param salesOrgCodeList  范围编码列表
     * @date 2023/05/16 10:42
     **/
    public Integer listByCalCodesAndSalesOrgCodes(List<String> budgetCalCodeList, List<String> salesOrgCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList) || CollectionUtils.isEmpty(salesOrgCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .eq(BudgetCalConfigSalesOrgEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(BudgetCalConfigSalesOrgEntity::getTenantCode, TenantUtils.getTenantCode())
                .in(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCodeList)
                .in(BudgetCalConfigSalesOrgEntity::getSalesOrgCode, salesOrgCodeList).count();
    }
}
