package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigAreaEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigProductRatioEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigScopeProductEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigScopeProductMapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 预算计算配置预算范围产品
 *
 * @author : rentao
 * @date : 2023/2/1 18:44
 */
@Component
public class BudgetCalConfigScopeProductRepository extends ServiceImpl<BudgetCalConfigScopeProductMapper, BudgetCalConfigScopeProductEntity> {

  /**
   * 根据计算配置编码查询
   *
   * @param budgetCalCode
   * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigScopeProductEntity>
   * @author huojia
   * @date 2022/11/2 23:29
   **/
  public List<BudgetCalConfigScopeProductEntity> listByCalConfigCode(String budgetCalCode) {
    if (StringUtils.isEmpty(budgetCalCode)) {
      return Arrays.asList();
    }
    return this.lambdaQuery()
            .eq(BudgetCalConfigScopeProductEntity::getBudgetCalCode, budgetCalCode)
            .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
            .list();
  }


  /**
   * 根据预算计算配置编码逻辑范围
   *
   * @param budgetCalCode
   * @author huojia
   * @date 2022/11/3 11:26
   **/
  public void delByBudgetCalCode(String budgetCalCode) {
    if (StringUtils.isEmpty(budgetCalCode)) {
      return;
    }
    List<BudgetCalConfigScopeProductEntity> list = this.lambdaQuery().eq(BudgetCalConfigScopeProductEntity::getBudgetCalCode, budgetCalCode).list();
    if (!CollectionUtils.isEmpty(list)) {
      list.forEach(budgetCalConfigAreaEntity -> {
        budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
      });
      this.updateBatchById(list);
    }
  }

  /**
   * 批量逻辑删除
   *
   * @param budgetCalCodeList
   * @author huojia
   * @date 2022/11/3 11:40
   **/
  public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
    if (CollectionUtils.isEmpty(budgetCalCodeList)) {
      return;
    }
    List<BudgetCalConfigScopeProductEntity> list = this.lambdaQuery().in(BudgetCalConfigScopeProductEntity::getBudgetCalCode, budgetCalCodeList).list();
    if (!CollectionUtils.isEmpty(list)) {
      list.forEach(budgetCalConfigAreaEntity -> {
        budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
      });
      this.updateBatchById(list);
    }
  }
}
