package com.biz.crm.tpm.business.budget.cal.config.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigProductRatioDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigProductRatioService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description 预算计算配置产品计费比例接口实现
 * @Author YangWei
 * @Date 2023/2/10 下午4:14
 */
@Slf4j
@Service("budgetCalConfigProductRatioService")
public class BudgetCalConfigProductRatioServiceImpl extends MnPageCacheServiceImpl<BudgetCalConfigProductRatioVo,BudgetCalConfigProductRatioDto> implements BudgetCalConfigProductRatioService {

    @Autowired(required = false)
    private RedisService redisService;

    @Autowired(required = false)
    private RedisTemplate<String, Object> redisTemplate;

    @Override
    public Page<BudgetCalConfigProductRatioVo> findCachePageList(Pageable pageable, BudgetCalConfigProductRatioDto dto, String cacheKey) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = this.helper.getRedisCacheInitKey(cacheKey);
        Page<BudgetCalConfigProductRatioVo> page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords(Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheIdKey)) {
            Long total = this.redisService.lSize(redisCacheIdKey);
            page.setTotal(total);
            List<Object> idList = this.redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty(idList)) {
                List<Object> dataList = this.redisTemplate.opsForHash().multiGet(redisCacheDataKey, idList);
                String dataListJson = JSONArray.toJSONString(dataList);
                List<BudgetCalConfigProductRatioDto> ratioDtos = JSONArray.parseArray(dataListJson, BudgetCalConfigProductRatioDto.class);
                //过滤
                List<BudgetCalConfigProductRatioDto> filterDto = ratioDtos.stream()
                    .filter(o ->
                        ((StringUtils.hasText(dto.getProductCode()) && o.getProductCode().contains(dto.getProductCode())) || !StringUtils.hasText(dto.getProductCode()))
                        && ((StringUtils.hasText(dto.getProductName()) && o.getProductName().contains(dto.getProductName())) || !StringUtils.hasText(dto.getProductName()))
                    )
                    .collect(Collectors.toList());
                List<BudgetCalConfigProductRatioVo> voList = this.helper.dtoListToVoList(filterDto);
                page.setRecords(voList);
            }
        } else if (!this.redisService.hasKey(redisCacheInitKey) && null != dto) {
            this.redisService.set(redisCacheInitKey, BooleanEnum.TRUE, this.helper.getExpireTime());
            List<BudgetCalConfigProductRatioDto> dtoList = this.helper.findDtoListFromRepository(dto, cacheKey);
            if (!CollectionUtils.isEmpty(dtoList)) {
                if (this.helper.initToCacheFromRepository()) {
                    this.helper.putCache(cacheKey, dtoList);
                }

                page.setTotal((long)dtoList.size());
                long start = page.offset();
                if (page.getTotal() > start) {
                    long end = page.offset() + page.getSize();
                    if (page.getTotal() < end) {
                        end = page.getTotal();
                    }

                    List<BudgetCalConfigProductRatioDto> recordDtoList = dtoList.subList((int)page.offset(), (int)end);
                    List<BudgetCalConfigProductRatioVo> voList = this.helper.dtoListToVoList(recordDtoList);
                    page.setRecords(voList);
                }
            }
        }

        this.helper.fillVoListProperties(page.getRecords());
        return page;
    }
}