package com.biz.crm.tpm.business.budget.cal.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.*;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigMapper;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.*;
import com.biz.crm.tpm.business.budget.cal.config.sdk.constant.BudgetCalConfigConstant;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.*;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.*;
import com.biz.crm.tpm.business.budget.cal.config.sdk.event.BudgetCalConfigLogEventListener;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigProductRatioService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.*;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.NumberUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

/**
 * @author huojia
 * @date 2022年11月02日 15:23
 */
@Slf4j
@Service
public class BudgetCalConfigServiceImpl implements BudgetCalConfigService {

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private BudgetCalConfigMapper budgetCalConfigMapper;

    @Autowired(required = false)
    private BudgetCalConfigRepository budgetCalConfigRepository;

    @Autowired(required = false)
    private BudgetCalConfigDataRepository budgetCalConfigDataRepository;

    @Autowired(required = false)
    private BudgetCalConfigAreaRepository budgetCalConfigAreaRepository;

    @Autowired(required = false)
    private BudgetCalConfigSalesOrgRepository budgetCalConfigSalesOrgRepository;

    @Autowired(required = false)
    private BudgetCalConfigProductRatioRepository budgetCalConfigProductRatioRepository;

    @Autowired(required = false)
    private BudgetCalConfigScopeProductRepository budgetCalConfigScopeProductRepository;

    @Resource
    private BudgetCalConfigProductRatioService budgetCalConfigProductRatioService;

    private final int LENGTH = 30;

    /**
     * 分页查询
     *
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo>
     * @author huojia
     * @date 2022/11/2 22:50
     **/
    @Override
    public Page<BudgetCalConfigVo> findByConditions(Pageable pageable, BudgetCalConfigDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new BudgetCalConfigDto();
        }
        Page<BudgetCalConfigVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.budgetCalConfigMapper.findByConditions(page, dto);
    }

    /**
     * 根据id查询预算计算配置
     *
     * @return com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo
     * @author huojia
     * @date 2022/11/2 23:01
     **/
    @Override
    public BudgetCalConfigVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        BudgetCalConfigEntity budgetCalConfigEntity = budgetCalConfigRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull(budgetCalConfigEntity, "数据不存在，请刷新后重试！");
        return this.buildVo(budgetCalConfigEntity);
    }

    /**
     * 构建返回vo
     *
     * @param budgetCalConfigEntity
     * @return com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo
     * @author huojia
     * @date 2022/11/2 23:24
     **/
    private BudgetCalConfigVo buildVo(BudgetCalConfigEntity budgetCalConfigEntity) {
        if (Objects.isNull(budgetCalConfigEntity)){
            return null;
        }
        List<BudgetCalConfigSalesOrgEntity> salesOrgEntities = budgetCalConfigSalesOrgRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());
        List<BudgetCalConfigAreaEntity> areaEntities = budgetCalConfigAreaRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());
        List<BudgetCalConfigDataEntity> dataEntities = budgetCalConfigDataRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());
        String budgetCalCode = budgetCalConfigEntity.getBudgetCalCode();
        BudgetCalConfigProductRatioDto ratioDto = new BudgetCalConfigProductRatioDto();
        ratioDto.setBudgetCalCode(budgetCalCode);
        List<BudgetCalConfigProductRatioEntity> ratioEntities = budgetCalConfigProductRatioRepository.listByCalConfigCode(ratioDto);
        List<BudgetCalConfigScopeProductEntity> scopeProductEntities = budgetCalConfigScopeProductRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());

        BudgetCalConfigVo budgetCalConfigVo = this.nebulaToolkitService.copyObjectByWhiteList(budgetCalConfigEntity, BudgetCalConfigVo.class, LinkedHashSet.class, ArrayList.class);
        if (!CollectionUtils.isEmpty(salesOrgEntities)) {
            budgetCalConfigVo.setSalesOrgList(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(salesOrgEntities, BudgetCalConfigSalesOrgEntity.class, BudgetCalConfigSalesOrgVo.class, LinkedHashSet.class, ArrayList.class)));
        }
        if (!CollectionUtils.isEmpty(areaEntities)) {
            List<BudgetCalConfigAreaEntity> customerList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.CUSTOMER.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            List<BudgetCalConfigAreaEntity> productList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.PRODUCT.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            List<BudgetCalConfigAreaEntity> terminalList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.TERMINAL.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            List<BudgetCalConfigAreaEntity> budgetItemList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.BUDGET_ITEM.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(customerList)) {
                budgetCalConfigVo.setCustomerList(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(customerList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class)));
            }
            if (!CollectionUtils.isEmpty(productList)) {
                budgetCalConfigVo.setProductList(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(productList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class)));
            }
            if (!CollectionUtils.isEmpty(terminalList)) {
                budgetCalConfigVo.setTerminalList(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(terminalList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class)));
            }
            if (!CollectionUtils.isEmpty(budgetItemList)) {
                List<BudgetCalConfigAreaVo> budgetCalConfigAreaVos = (List)nebulaToolkitService.copyCollectionByWhiteList(budgetItemList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class);
                if(!CollectionUtils.isEmpty(scopeProductEntities)){
                    List<BudgetCalConfigScopeProductVo> budgetCalConfigScopeProductVos = (List)nebulaToolkitService.copyCollectionByWhiteList(scopeProductEntities, BudgetCalConfigScopeProductEntity.class, BudgetCalConfigScopeProductVo.class, LinkedHashSet.class, ArrayList.class);
                    Map<String, List<BudgetCalConfigScopeProductVo>> scopeProductMap = budgetCalConfigScopeProductVos.stream().collect(Collectors.groupingBy(BudgetCalConfigScopeProductVo::getConfigAreaId));
                    budgetCalConfigAreaVos.forEach(budgetCalConfigAreaVo->{
                        List<BudgetCalConfigScopeProductVo> budgetCalConfigScopeProductEntities = scopeProductMap.get(budgetCalConfigAreaVo.getId());
                        budgetCalConfigAreaVo.setScopeProducts(budgetCalConfigScopeProductEntities);
                    });
                }
                budgetCalConfigVo.setBudgetItemList(budgetCalConfigAreaVos);
            }
        }
        if (!CollectionUtils.isEmpty(dataEntities)) {
            budgetCalConfigVo.setDataList(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(dataEntities, BudgetCalConfigDataEntity.class, BudgetCalConfigDataVo.class, LinkedHashSet.class, ArrayList.class)));
        }

        if (!CollectionUtils.isEmpty(ratioEntities)) {
            budgetCalConfigVo.setProductRatios(new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(ratioEntities, BudgetCalConfigProductRatioEntity.class, BudgetCalConfigProductRatioVo.class, LinkedHashSet.class, ArrayList.class)));
        }
        return budgetCalConfigVo;
    }

    /**
     * 新增
     *
     * @return com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo
     * @author huojia
     * @date 2022/11/2 23:01
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public BudgetCalConfigVo create(BudgetCalConfigDto dto) {
        this.createValidate(dto);
        BudgetCalConfigEntity budgetCalConfigEntity = this.nebulaToolkitService.copyObjectByWhiteList(dto, BudgetCalConfigEntity.class, LinkedHashSet.class, ArrayList.class);
        this.budgetCalConfigRepository.saveOrUpdate(budgetCalConfigEntity);
        // 新增包含销售组织
        if (!CollectionUtils.isEmpty(dto.getSalesOrgList())) {
            List<BudgetCalConfigSalesOrgEntity> budgetCalConfigSalesOrgEntities = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(dto.getSalesOrgList(), BudgetCalConfigSalesOrgDto.class, BudgetCalConfigSalesOrgEntity.class, LinkedHashSet.class, ArrayList.class));
            budgetCalConfigSalesOrgEntities.forEach(o -> {
                o.setId(null);
            });
            budgetCalConfigSalesOrgRepository.saveBatch(budgetCalConfigSalesOrgEntities);
        }
        // 新增非包含范围
        List<BudgetCalConfigAreaDto> budgetCalConfigAreaDtoList = new ArrayList<>();
        budgetCalConfigAreaDtoList.addAll(dto.getCustomerList());
        budgetCalConfigAreaDtoList.addAll(dto.getProductList());
        budgetCalConfigAreaDtoList.addAll(dto.getTerminalList());
//        budgetCalConfigAreaDtoList.addAll(dto.getBudgetItemList());
        if (!CollectionUtils.isEmpty(budgetCalConfigAreaDtoList)) {
            List<BudgetCalConfigAreaEntity> budgetCalConfigAreaEntities = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(budgetCalConfigAreaDtoList, BudgetCalConfigAreaDto.class, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class));
            budgetCalConfigAreaEntities.forEach(o -> {
                o.setId(null);
            });
            budgetCalConfigAreaRepository.saveBatch(budgetCalConfigAreaEntities);
        }
        if(!CollectionUtils.isEmpty(dto.getBudgetItemList())){
            dto.getBudgetItemList().forEach(budgetCalConfigAreaDto -> {
                BudgetCalConfigAreaEntity budgetCalConfigAreaEntity = this.nebulaToolkitService.copyObjectByWhiteList(budgetCalConfigAreaDto, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class);
                budgetCalConfigAreaEntity.setId(null);
                budgetCalConfigAreaRepository.save(budgetCalConfigAreaEntity);
                if(!CollectionUtils.isEmpty(budgetCalConfigAreaDto.getScopeProducts())){
                    List<BudgetCalConfigScopeProductEntity> entities = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(budgetCalConfigAreaDto.getScopeProducts(), BudgetCalConfigScopeProductDto.class, BudgetCalConfigScopeProductEntity.class, LinkedHashSet.class, ArrayList.class));
                    entities.forEach(budgetCalConfigScopeProductEntity -> {
                        budgetCalConfigScopeProductEntity.setId(null);
                        budgetCalConfigScopeProductEntity.setConfigAreaId(budgetCalConfigAreaEntity.getId());
                    });
                    budgetCalConfigScopeProductRepository.saveBatch(entities);
                }
            });
        }
        //计算比例
        String cacheKey = dto.getCacheKey();
        if(org.springframework.util.StringUtils.hasText(cacheKey)){
            //缓存中获取计费比例
            List<BudgetCalConfigProductRatioDto> ratioDtos = budgetCalConfigProductRatioService.findCacheList(cacheKey);
            //添加索引，报错的时候带上行索引
            if (!CollectionUtils.isEmpty(ratioDtos)) {
                for (int i = 0; i < ratioDtos.size(); i++) {
                    ratioDtos.get(i).setIndexNo(i + 1);
                    if (ratioDtos.get(i).getChargedRatio() == null){
                        throw new RuntimeException("产品计费比列第" + (i+1) + "行计费点数不能为空");
                    }
                }
            }
            dto.setProductRatioVos(ratioDtos);
        }
        if (!CollectionUtils.isEmpty(dto.getProductRatioVos())) {
            List<BudgetCalConfigProductRatioEntity> budgetCalConfigProductRatioEntities = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(dto.getProductRatioVos(), BudgetCalConfigProductRatioDto.class, BudgetCalConfigProductRatioEntity.class, LinkedHashSet.class, ArrayList.class));
            budgetCalConfigProductRatioEntities.forEach(o -> {
                o.setBudgetCalCode(budgetCalConfigEntity.getBudgetCalCode());
            });
            budgetCalConfigProductRatioRepository.saveBatch(budgetCalConfigProductRatioEntities);
        }
        // 新增数据配置
        if (!CollectionUtils.isEmpty(dto.getDataList())) {
            List<BudgetCalConfigDataEntity> budgetCalConfigDataEntities = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(dto.getDataList(), BudgetCalConfigDataDto.class, BudgetCalConfigDataEntity.class, LinkedHashSet.class, ArrayList.class));
            budgetCalConfigDataEntities.forEach(o -> {
                o.setId(null);
            });
            budgetCalConfigDataRepository.saveBatch(budgetCalConfigDataEntities);
        }
        // 业务日志新增
        BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<BudgetCalConfigLogEventListener, BudgetCalConfigLogEventDto> onCreate =
                BudgetCalConfigLogEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, BudgetCalConfigLogEventListener.class, onCreate);
        return this.nebulaToolkitService.copyObjectByWhiteList(dto, BudgetCalConfigVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 校验新增数据
     * 根据预算类型、业态、业务单元验证重复，同时数据配置根据客户类型做校验，一条计算配置，不能有重复的客户类型
     *
     * @param dto
     * @author huojia
     * @date 2022/11/3 10:02
     **/
    private void createValidate(BudgetCalConfigDto dto) {
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getBudgetCalName(), "预算计算配置名称不能为空！");
        Validate.notEmpty(dto.getBudgetTypeCode(), "预算类型不能为空！");
        Validate.notEmpty(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notEmpty(dto.getBusinessUnitCode(), "业务单元不能为空！");
        if(BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())){
            Validate.notEmpty(dto.getGroupCode(), "分组不能为空！");
        }
        Validate.notNull(dto.getEffectBeginTime(), "生效起始时间不能为空！");
        Validate.notNull(dto.getEffectEndTime(), "生效结束时间不能为空！");
        if (dto.getEffectBeginTime().after(dto.getEffectEndTime())) {
            throw new RuntimeException("生效起始时间不能在生效结束时间之后");
        }
        // 数据配置，客户类型不能重复存在（最多只有[客户类型种类数]条）
        Validate.notEmpty(dto.getDataList(), "数据配置不能为空！");
        /*Map<String, BudgetCalConfigDataDto> dataMap = dto.getDataList().stream()
                .collect(Collectors.toMap(BudgetCalConfigDataDto::getCustomerTypeCode, Function.identity(), (oldVo, newVo) -> newVo));
        if (dataMap.size() < dto.getDataList().size()) {
            throw new RuntimeException("不能维护相同客户类型！");
        }*/
        // 验证重复
        /*List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByConditions(dto);
        if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            throw new RuntimeException("存在相同维度预算计算配置数据，请检查！");
        }*/
        // 年度预算只能维护销售任务
        if (BudgetTypeEnum.YEAR_BUDGET.getCode().equals(dto.getBudgetTypeCode())) {
            List<BudgetCalConfigDataDto> collect = dto.getDataList().stream()
                    .filter(data -> !CalDataFromEnum.SALES_GOAL.getCode().equals(data.getCalDataFromCode()))
                    .collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(collect)) {
                throw new RuntimeException("年度预算的数据来源只能维护销售任务！");
            }
        }
        // 主表设置公用值
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
//        String ruleCode = StringUtils.join(BudgetCalConfigConstant.BUDGET_CAL_CONFIG_CODE, DateFormatUtils.format(new Date(), DateUtil.DEFAULT_YEAR_MONTH_DAY_NO_CH));
        dto.setBudgetCalCode(generateCodeService.generateCode(BudgetCalConfigConstant.BUDGET_CAL_CONFIG_CODE, 1, 6, 2, TimeUnit.DAYS).get(0));
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(dto.getOrgAreaCode())
                && CollectionUtils.isEmpty(dto.getSalesOrgList())) {
            throw new RuntimeException("包含组织为自定组织，销售组织不能为空！");
        }
        // 包含销售组织
        if (!CollectionUtils.isEmpty(dto.getSalesOrgList())) {
            dto.getSalesOrgList().forEach(salesOrg -> {
                Validate.notEmpty(salesOrg.getSalesOrgCode(), "销售组织编码不能为空！");
                Validate.notEmpty(salesOrg.getSalesOrgName(), "销售组织名称不能为空！");
                salesOrg.setId(null);
                salesOrg.setTenantCode(TenantUtils.getTenantCode());
                salesOrg.setBudgetCalCode(dto.getBudgetCalCode());
                salesOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                salesOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            });
        }
        // 明细表设置公用值
        if (!CollectionUtils.isEmpty(dto.getCustomerList())) {
            dto.getCustomerList().forEach(customer -> {
                Validate.notEmpty(customer.getDataCode(), "客户编码不能为空！");
                Validate.notEmpty(customer.getDataName(), "客户名称不能为空！");
                customer.setId(null);
                customer.setTenantCode(TenantUtils.getTenantCode());
                customer.setBudgetCalCode(dto.getBudgetCalCode());
                customer.setAreaTypeCode(CalAreaTypeEnum.CUSTOMER.getCode());
                customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty(dto.getProductList())) {
            dto.getProductList().forEach(product -> {
                Validate.notEmpty(product.getDataCode(), "产品编码不能为空！");
                Validate.notEmpty(product.getDataName(), "产品名称不能为空！");
                product.setId(null);
                product.setTenantCode(TenantUtils.getTenantCode());
                product.setBudgetCalCode(dto.getBudgetCalCode());
                product.setAreaTypeCode(CalAreaTypeEnum.PRODUCT.getCode());
                product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty(dto.getTerminalList())) {
            dto.getTerminalList().forEach(terminal -> {
                Validate.notEmpty(terminal.getDataCode(), "门店编码不能为空！");
                Validate.notEmpty(terminal.getDataName(), "门店名称不能为空！");
                terminal.setId(null);
                terminal.setTenantCode(TenantUtils.getTenantCode());
                terminal.setBudgetCalCode(dto.getBudgetCalCode());
                terminal.setAreaTypeCode(CalAreaTypeEnum.TERMINAL.getCode());
                terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty(dto.getBudgetItemList())) {
            dto.getBudgetItemList().forEach(budgetItem -> {
                Validate.notEmpty(budgetItem.getDataCode(), "预算项目编码不能为空！");
                Validate.notEmpty(budgetItem.getDataName(), "预算项目名称不能为空！");
                budgetItem.setId(null);
                budgetItem.setTenantCode(TenantUtils.getTenantCode());
                budgetItem.setBudgetCalCode(dto.getBudgetCalCode());
                budgetItem.setAreaTypeCode(CalAreaTypeEnum.BUDGET_ITEM.getCode());
                budgetItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                if(!CollectionUtils.isEmpty(budgetItem.getScopeProducts())){
                    budgetItem.getScopeProducts().forEach(budgetCalConfigScopeProductDto -> {
                        Validate.notEmpty(budgetCalConfigScopeProductDto.getProductCode(), "产品计费比例产品编码不能为空！");
                        Validate.notEmpty(budgetCalConfigScopeProductDto.getProductName(), "产品计费比例产品名称不能为空！");
                        budgetCalConfigScopeProductDto.setId(null);
                        budgetCalConfigScopeProductDto.setTenantCode(TenantUtils.getTenantCode());
                        budgetCalConfigScopeProductDto.setBudgetCalCode(dto.getBudgetCalCode());
                        budgetCalConfigScopeProductDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    });
                }
            });
        }
        //验证计算比例
        if(!CollectionUtils.isEmpty(dto.getProductRatioVos())){
            dto.getProductRatioVos().forEach(budgetCalConfigProductRatioDto -> {
                Validate.notEmpty(budgetCalConfigProductRatioDto.getProductCode(), "产品计费比例产品编码不能为空！");
                Validate.notEmpty(budgetCalConfigProductRatioDto.getProductName(), "产品计费比例产品名称不能为空！");
                budgetCalConfigProductRatioDto.setId(null);
                budgetCalConfigProductRatioDto.setTenantCode(TenantUtils.getTenantCode());
                budgetCalConfigProductRatioDto.setBudgetCalCode(dto.getBudgetCalCode());
                budgetCalConfigProductRatioDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        // 验证重复
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByConditions(dto);
        AtomicReference<Boolean> dataB = new AtomicReference<>(false);
        dto.getDataList().forEach(data -> {
            Validate.notEmpty(data.getCalDataFromCode(), "数据类型不能为空！");
            Validate.notEmpty(data.getAmountTypeCode(), "金额类型不能为空！");
            data.setId(null);
            data.setTenantCode(TenantUtils.getTenantCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            data.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
                List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
                List<BudgetCalConfigDataEntity> budgetCalConfigDataEntityList = budgetCalConfigDataRepository.listByConditions(budgetCalCodeList, data);
                if (!CollectionUtils.isEmpty(budgetCalConfigDataEntityList)) {
//                    throw new RuntimeException("存在相同维度的预算计算数据配置，请检查！");
                    dataB.set(true);
                }
            }
        });
        if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
            //若主信息和数据配置重复，则需要校验预算范围是否重复，若无预算范围，则判断
            if (dataB.get()) {
                if (!CollectionUtils.isEmpty(dto.getBudgetItemList())) {
                    //若有预算范围，则判断预算范围是否重复
                    List<String> itemCodeList = dto.getBudgetItemList().stream().map(BudgetCalConfigAreaDto::getDataCode).collect(Collectors.toList());
                    Integer count = budgetCalConfigAreaRepository.listByCalCodesAndItemCodes(budgetCalCodeList, itemCodeList);
                    if (!Objects.isNull(count) && count > 0) {
                        throw new RuntimeException("预算计算基本信息+预算范围+数据配置存在相同维度，请检查！");
                    }
                } else {
                    //若无预算范围，则判断无预算范围的预算计算配置是否存在
                    List<BudgetCalConfigAreaEntity> entities = budgetCalConfigAreaRepository.listByCalCodes(budgetCalCodeList);
                    if (CollectionUtils.isEmpty(entities)) {
                        throw new RuntimeException("预算计算基本信息+数据配置存在相同维度，请检查！");
                    } else {
                        List<String> calCodes = entities.stream().map(BudgetCalConfigAreaEntity::getBudgetCalCode).distinct().collect(Collectors.toList());
                        budgetCalCodeList.removeAll(calCodes);
                        if (!CollectionUtils.isEmpty(budgetCalCodeList)) {
                            throw new RuntimeException("预算计算基本信息+数据配置存在相同维度，请检查！");
                        }
                    }
                }
            }
        }
    }

    /**
     * 编辑
     *
     * @return com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo
     * @author huojia
     * @date 2022/11/2 23:01
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public BudgetCalConfigVo update(BudgetCalConfigDto dto) {
        this.updateValidate(dto);
        BudgetCalConfigVo budgetCalConfigVo = this.findById(dto.getId());
        if (ObjectUtils.isEmpty(budgetCalConfigVo)) {
            throw new RuntimeException("修改数据失败，原数据不存在！");
        }
        if (dto.getBudgetCalName().length() > LENGTH){
            throw new IllegalArgumentException("预算计算名称过长");
        }
        // 保存预算项目
        BudgetCalConfigDto oldVo = this.nebulaToolkitService.copyObjectByWhiteList(budgetCalConfigVo, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class);
        BudgetCalConfigEntity budgetCalConfigEntity = this.nebulaToolkitService.copyObjectByWhiteList(dto, BudgetCalConfigEntity.class, LinkedHashSet.class, ArrayList.class);
        budgetCalConfigRepository.updateById(budgetCalConfigEntity);
        // 保存包含销售组织
        budgetCalConfigSalesOrgRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        if (!CollectionUtils.isEmpty(dto.getSalesOrgList())) {
            Collection<BudgetCalConfigSalesOrgEntity> budgetCalConfigSalesOrgEntities = this.nebulaToolkitService.copyCollectionByBlankList(dto.getSalesOrgList(), BudgetCalConfigSalesOrgDto.class, BudgetCalConfigSalesOrgEntity.class, LinkedHashSet.class, ArrayList.class);
            budgetCalConfigSalesOrgEntities.forEach(o -> {
                o.setId(null);
            });
            budgetCalConfigSalesOrgRepository.saveBatch(new ArrayList<>(budgetCalConfigSalesOrgEntities));
        }
        // 保存范围
        budgetCalConfigAreaRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        budgetCalConfigScopeProductRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        List<BudgetCalConfigAreaDto> areaList = new ArrayList<>();
        areaList.addAll(dto.getCustomerList());
        areaList.addAll(dto.getProductList());
        areaList.addAll(dto.getTerminalList());
        //areaList.addAll(dto.getBudgetItemList());
        if (!CollectionUtils.isEmpty(areaList)) {
            Collection<BudgetCalConfigAreaEntity> budgetCalConfigAreaEntities = this.nebulaToolkitService.copyCollectionByBlankList(
                    areaList, BudgetCalConfigAreaDto.class, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class
            );
            budgetCalConfigAreaEntities.forEach(o -> {
                o.setId(null);
            });
            budgetCalConfigAreaRepository.saveBatch(new ArrayList<>(budgetCalConfigAreaEntities));
        }
        //
        if(!CollectionUtils.isEmpty(dto.getBudgetItemList())){
            dto.getBudgetItemList().forEach(budgetCalConfigAreaDto -> {
                BudgetCalConfigAreaEntity budgetCalConfigAreaEntity = this.nebulaToolkitService.copyObjectByWhiteList(budgetCalConfigAreaDto, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class);
                budgetCalConfigAreaEntity.setId(null);
                budgetCalConfigAreaRepository.save(budgetCalConfigAreaEntity);
                if(!CollectionUtils.isEmpty(budgetCalConfigAreaDto.getScopeProducts())){
                    List<BudgetCalConfigScopeProductEntity> entities = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(budgetCalConfigAreaDto.getScopeProducts(), BudgetCalConfigScopeProductDto.class, BudgetCalConfigScopeProductEntity.class, LinkedHashSet.class, ArrayList.class));
                    entities.forEach(budgetCalConfigScopeProductEntity -> {
                        budgetCalConfigScopeProductEntity.setId(null);
                        budgetCalConfigScopeProductEntity.setConfigAreaId(budgetCalConfigAreaEntity.getId());
                    });
                    budgetCalConfigScopeProductRepository.saveBatch(entities);
                }
            });
        }
        //计算比例
        budgetCalConfigProductRatioRepository.delByBudgetCalCodes(Lists.newArrayList(dto.getBudgetCalCode()));
        String cacheKey = dto.getCacheKey();
        if(org.springframework.util.StringUtils.hasText(cacheKey)){
            //缓存中获取计费比例
            List<BudgetCalConfigProductRatioDto> ratioDtos = budgetCalConfigProductRatioService.findCacheList(cacheKey);
            //添加报错行索引
            if (!CollectionUtils.isEmpty(ratioDtos)) {
                for (int i = 0; i < ratioDtos.size(); i++) {
                    ratioDtos.get(i).setIndexNo(i + 1);
                    if (ratioDtos.get(i).getChargedRatio() == null){
                        throw new RuntimeException("产品计费比列第" + (i+1) + "行计费点数不能为空");
                    }
                }
            }
            dto.setProductRatioVos(ratioDtos);
        }
        if (!CollectionUtils.isEmpty(dto.getProductRatioVos())) {
            List<BudgetCalConfigProductRatioEntity> budgetCalConfigProductRatioEntities = new ArrayList<>(nebulaToolkitService.copyCollectionByWhiteList(dto.getProductRatioVos(), BudgetCalConfigProductRatioDto.class, BudgetCalConfigProductRatioEntity.class, LinkedHashSet.class, ArrayList.class));
            budgetCalConfigProductRatioEntities.forEach(o -> {
                o.setBudgetCalCode(budgetCalConfigEntity.getBudgetCalCode());
            });
            budgetCalConfigProductRatioRepository.saveBatch(budgetCalConfigProductRatioEntities);
        }
        // 保存数据配置
        budgetCalConfigDataRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        if (!CollectionUtils.isEmpty(dto.getDataList())) {
            Collection<BudgetCalConfigDataEntity> budgetCalConfigDataEntities = this.nebulaToolkitService.copyCollectionByBlankList(dto.getDataList(), BudgetCalConfigDataDto.class, BudgetCalConfigDataEntity.class, LinkedHashSet.class, ArrayList.class);
            budgetCalConfigDataEntities.forEach(o -> {
                o.setId(null);
            });
            budgetCalConfigDataRepository.saveBatch(budgetCalConfigDataEntities);
        }
        // 业务日志编辑
        BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer<BudgetCalConfigLogEventListener, BudgetCalConfigLogEventDto> onUpdate =
                BudgetCalConfigLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, BudgetCalConfigLogEventListener.class, onUpdate);
        return this.nebulaToolkitService.copyObjectByWhiteList(dto, BudgetCalConfigVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 编辑校验
     *
     * @param dto
     * @author huojia
     * @date 2022/11/3 11:16
     **/
    private void updateValidate(BudgetCalConfigDto dto) {
        Validate.notNull(dto, "请求参数不能为空！");
        Validate.notEmpty(dto.getBudgetCalName(), "预算计算配置名称不能为空！");
        Validate.notEmpty(dto.getBudgetTypeCode(), "预算类型不能为空！");
        Validate.notEmpty(dto.getBusinessFormatCode(), "业态不能为空！");
        Validate.notEmpty(dto.getBusinessUnitCode(), "业务单元不能为空！");
        if(BusinessUnitEnum.isDefaultBusinessUnit(dto.getBusinessUnitCode())){
            Validate.notEmpty(dto.getGroupCode(), "分组不能为空！");
        }
        Validate.notNull(dto.getEffectBeginTime(), "生效起始时间不能为空！");
        Validate.notNull(dto.getEffectEndTime(), "生效结束时间不能为空！");
        if (dto.getEffectBeginTime().after(dto.getEffectEndTime())) {
            throw new RuntimeException("生效起始时间不能在生效结束时间之后");
        }
        // 数据配置，客户类型不能重复存在（最多只有[客户类型种类数]条）
        Validate.notEmpty(dto.getDataList(), "数据配置不能为空！");
        /*Map<String, BudgetCalConfigDataDto> dataMap = dto.getDataList().stream()
                .collect(Collectors.toMap(BudgetCalConfigDataDto::getCustomerTypeCode, Function.identity(), (oldVo, newVo) -> newVo));
        if (dataMap.size() < dto.getDataList().size()) {
            throw new RuntimeException("不能维护相同客户类型！");
        }*/
        // 验证重复
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByConditions(dto);
//        if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
//            throw new RuntimeException("存在相同维度预算计算配置数据，请检查！");
//        }
        // 主表设置公用值
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(dto.getOrgAreaCode())
                && CollectionUtils.isEmpty(dto.getSalesOrgList())) {
            throw new RuntimeException("包含组织为自定组织，销售组织不能为空！");
        }
        // 包含销售组织
        if (!CollectionUtils.isEmpty(dto.getSalesOrgList())) {
            dto.getSalesOrgList().forEach(salesOrg -> {
                Validate.notEmpty(salesOrg.getSalesOrgCode(), "销售组织编码不能为空！");
                Validate.notEmpty(salesOrg.getSalesOrgName(), "销售组织名称不能为空！");
                salesOrg.setTenantCode(TenantUtils.getTenantCode());
                salesOrg.setBudgetCalCode(dto.getBudgetCalCode());
                salesOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                salesOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            });
        }
        // 明细表设置公用值
        if (!CollectionUtils.isEmpty(dto.getCustomerList())) {
            dto.getCustomerList().forEach(customer -> {
                Validate.notEmpty(customer.getDataCode(), "客户编码不能为空！");
                Validate.notEmpty(customer.getDataName(), "客户名称不能为空！");
                customer.setTenantCode(TenantUtils.getTenantCode());
                customer.setBudgetCalCode(dto.getBudgetCalCode());
                customer.setAreaTypeCode(CalAreaTypeEnum.CUSTOMER.getCode());
                customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty(dto.getProductList())) {
            dto.getProductList().forEach(product -> {
                Validate.notEmpty(product.getDataCode(), "产品编码不能为空！");
                Validate.notEmpty(product.getDataName(), "产品名称不能为空！");
                product.setTenantCode(TenantUtils.getTenantCode());
                product.setBudgetCalCode(dto.getBudgetCalCode());
                product.setAreaTypeCode(CalAreaTypeEnum.PRODUCT.getCode());
                product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty(dto.getTerminalList())) {
            dto.getTerminalList().forEach(terminal -> {
                Validate.notEmpty(terminal.getDataCode(), "门店编码不能为空！");
                Validate.notEmpty(terminal.getDataName(), "门店名称不能为空！");
                terminal.setTenantCode(TenantUtils.getTenantCode());
                terminal.setBudgetCalCode(dto.getBudgetCalCode());
                terminal.setAreaTypeCode(CalAreaTypeEnum.TERMINAL.getCode());
                terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty(dto.getBudgetItemList())) {
            dto.getBudgetItemList().forEach(budgetItem -> {
                Validate.notEmpty(budgetItem.getDataCode(), "预算项目编码不能为空！");
                Validate.notEmpty(budgetItem.getDataName(), "预算项目名称不能为空！");
                budgetItem.setTenantCode(TenantUtils.getTenantCode());
                budgetItem.setBudgetCalCode(dto.getBudgetCalCode());
                budgetItem.setAreaTypeCode(CalAreaTypeEnum.BUDGET_ITEM.getCode());
                budgetItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                if(!CollectionUtils.isEmpty(budgetItem.getScopeProducts())){
                    budgetItem.getScopeProducts().forEach(budgetCalConfigScopeProductDto -> {
                        Validate.notEmpty(budgetCalConfigScopeProductDto.getProductCode(), "产品计费比例产品编码不能为空！");
                        Validate.notEmpty(budgetCalConfigScopeProductDto.getProductName(), "产品计费比例产品名称不能为空！");
                        budgetCalConfigScopeProductDto.setTenantCode(TenantUtils.getTenantCode());
                        budgetCalConfigScopeProductDto.setBudgetCalCode(dto.getBudgetCalCode());
                        budgetCalConfigScopeProductDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    });
                }
            });
        }
        //验证计算比例
        if(!CollectionUtils.isEmpty(dto.getProductRatioVos())){
            dto.getProductRatioVos().forEach(budgetCalConfigProductRatioDto -> {
                Validate.notEmpty(budgetCalConfigProductRatioDto.getProductCode(), "产品计费比例产品编码不能为空！");
                Validate.notEmpty(budgetCalConfigProductRatioDto.getProductName(), "产品计费比例产品名称不能为空！");
                budgetCalConfigProductRatioDto.setTenantCode(TenantUtils.getTenantCode());
                budgetCalConfigProductRatioDto.setBudgetCalCode(dto.getBudgetCalCode());
                budgetCalConfigProductRatioDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        dto.getDataList().forEach(data -> {
            Validate.notEmpty(data.getCalDataFromCode(), "数据类型不能为空！");
            Validate.notEmpty(data.getAmountTypeCode(), "金额类型不能为空！");
            data.setTenantCode(TenantUtils.getTenantCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            data.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
        });

        AtomicReference<Boolean> dataB = new AtomicReference<>(false);
        dto.getDataList().forEach(data -> {
            Validate.notEmpty(data.getCalDataFromCode(), "数据类型不能为空！");
            Validate.notEmpty(data.getAmountTypeCode(), "金额类型不能为空！");
            data.setId(null);
            data.setTenantCode(TenantUtils.getTenantCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            data.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
                List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
                List<BudgetCalConfigDataEntity> budgetCalConfigDataEntityList = budgetCalConfigDataRepository.listByConditions(budgetCalCodeList, data);
                if (!CollectionUtils.isEmpty(budgetCalConfigDataEntityList)) {
//                    throw new RuntimeException("存在相同维度的预算计算数据配置，请检查！");
                    dataB.set(true);
                }
            }
        });
        if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
            //若主信息和数据配置重复，则需要校验预算范围是否重复，若无预算范围，则判断
            if (dataB.get()) {
                if (!CollectionUtils.isEmpty(dto.getBudgetItemList())) {
                    //若有预算范围，则判断预算范围是否重复
                    List<String> itemCodeList = dto.getBudgetItemList().stream().map(BudgetCalConfigAreaDto::getDataCode).collect(Collectors.toList());
                    Integer count = budgetCalConfigAreaRepository.listByCalCodesAndItemCodes(budgetCalCodeList, itemCodeList);
                    if (!Objects.isNull(count) && count > 0) {
                        throw new RuntimeException("预算计算基本信息+预算范围+数据配置存在相同维度，请检查！");
                    }
                } else {
                    //若无预算范围，则判断无预算范围的预算计算配置是否存在
                    List<BudgetCalConfigAreaEntity> entities = budgetCalConfigAreaRepository.listByCalCodes(budgetCalCodeList);
                    if (CollectionUtils.isEmpty(entities)) {
                        throw new RuntimeException("预算计算基本信息+数据配置存在相同维度，请检查！");
                    } else {
                        List<String> calCodes = entities.stream().map(BudgetCalConfigAreaEntity::getBudgetCalCode).distinct().collect(Collectors.toList());
                        budgetCalCodeList.removeAll(calCodes);
                        if (!CollectionUtils.isEmpty(budgetCalCodeList)) {
                            throw new RuntimeException("预算计算基本信息+数据配置存在相同维度，请检查！");
                        }
                    }
                }
            }
        }
    }

    /**
     * 批量删除
     *
     * @author huojia
     * @date 2022/11/2 23:05
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择要删除的数据！");
        }
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByIds(ids);
        if (CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            return;
        }
        // 关联月度预算的不能删
        List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
        // 逻辑删除
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            budgetCalConfigEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
        });
        this.budgetCalConfigRepository.updateBatchById(budgetCalConfigEntities);
        this.budgetCalConfigSalesOrgRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigDataRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigAreaRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigProductRatioRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigScopeProductRepository.delByBudgetCalCodes(budgetCalCodeList);
        // 业务日志删除
        BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            logEventDto.setOriginal(this.nebulaToolkitService.copyObjectByWhiteList(budgetCalConfigEntity, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class));
            logEventDto.setNewest(null);
            SerializableBiConsumer<BudgetCalConfigLogEventListener, BudgetCalConfigLogEventDto> onDelete =
                    BudgetCalConfigLogEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, BudgetCalConfigLogEventListener.class, onDelete);
        });
    }

    /**
     * 启用
     *
     * @author huojia
     * @date 2022/11/2 23:05
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void enable(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择要启用的数据！");
        }
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            return;
        }
        budgetCalConfigEntities.forEach(budgetItemEntity -> {
            if (EnableStatusEnum.ENABLE.getCode().equals(budgetItemEntity.getEnableStatus())) {
                throw new RuntimeException("启用失败，只能选择禁用状态预算计算配置");
            }
            budgetItemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        this.budgetCalConfigRepository.updateBatchById(budgetCalConfigEntities);
        // 业务日志启用
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
            logEventDto.setOriginal(this.nebulaToolkitService.copyObjectByWhiteList(
                    budgetCalConfigEntity, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class
            ));
            logEventDto.setNewest(null);
            SerializableBiConsumer<BudgetCalConfigLogEventListener, BudgetCalConfigLogEventDto> onEnable =
                    BudgetCalConfigLogEventListener::onEnable;
            this.nebulaNetEventClient.publish(logEventDto, BudgetCalConfigLogEventListener.class, onEnable);
        });
    }

    /**
     * 禁用
     *
     * @author huojia
     * @date 2022/11/2 23:05
     **/
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void disable(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("请选择要禁用的数据");
        }
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            return;
        }
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            if (EnableStatusEnum.DISABLE.getCode().equals(budgetCalConfigEntity.getEnableStatus())) {
                throw new RuntimeException("禁用失败，只能选择启用状态预算计算配置");
            }
            budgetCalConfigEntity.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        });
        this.budgetCalConfigRepository.updateBatchById(budgetCalConfigEntities);
        // 业务日志启用
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
            logEventDto.setOriginal(this.nebulaToolkitService.copyObjectByWhiteList(
                    budgetCalConfigEntity, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class
            ));
            logEventDto.setNewest(null);
            SerializableBiConsumer<BudgetCalConfigLogEventListener, BudgetCalConfigLogEventDto> onDisable =
                    BudgetCalConfigLogEventListener::onDisable;
            this.nebulaNetEventClient.publish(logEventDto, BudgetCalConfigLogEventListener.class, onDisable);
        });
    }

    /**
     * 条件查询
     *
     * @param budgetCalConfigDto
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo>
     * @author huojia
     * @date 2022/11/3 17:17
     **/
    @Override
    public List<BudgetCalConfigVo> listByConditions(BudgetCalConfigDto budgetCalConfigDto) {
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByConditions(budgetCalConfigDto);
        if (CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            return Lists.newArrayList();
        }
        List<BudgetCalConfigVo> result = new ArrayList<>();
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            result.add(this.buildVo(budgetCalConfigEntity));
        });
        return result;
    }

    /**
     * 根据预算类型、数据来源查询
     *
     * @param type
     * @param code
     * @return java.util.List<com.biz.crm.mn.common.base.vo.CommonSelectVo>
     * @author huojia
     * @date 2023/1/10 22:23
     **/
    @Override
    public List<CommonSelectVo> listSelect(String type, String code) {
        List<CommonSelectVo> commonSelectVoList = new ArrayList<>();
        if (BooleanEnum.TRUE.getCapital().equals(type)) {

            if (StringUtils.isEmpty(code) || BudgetTypeEnum.YEAR_BUDGET.getCode().equals(code)) {
                CommonSelectVo commonSelectVo = new CommonSelectVo();
                commonSelectVo.setCode(CalDataFromEnum.SALES_GOAL.getCode());
                commonSelectVo.setValue(CalDataFromEnum.SALES_GOAL.getDesc());
                commonSelectVoList.add(commonSelectVo);
            }

            if (StringUtils.isEmpty(code) || BudgetTypeEnum.MONTH_BUDGET.getCode().equals(code)) {
                CommonSelectVo planSelectVo = new CommonSelectVo();
                planSelectVo.setCode(CalDataFromEnum.SALES_PLAN.getCode());
                planSelectVo.setValue(CalDataFromEnum.SALES_PLAN.getDesc());
                commonSelectVoList.add(planSelectVo);
                CommonSelectVo commonSelectVo = new CommonSelectVo();
                commonSelectVo.setCode(CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode());
                commonSelectVo.setValue(CalDataFromEnum.ACTUAL_SALES_AMOUNT.getDesc());
                commonSelectVoList.add(commonSelectVo);
            }
            return commonSelectVoList;
        } else {
            List<String> salesGoalList = SalesGoalAmountTypeEnum.concertEnumToList();
            Map<String, String> salesGoalMap = SalesGoalAmountTypeEnum.concertEnumToMap();

            List<String> salesPlanList = SalesPlanAmountTypeEnum.concertEnumToList();
            Map<String, String> salesPlanMap = SalesPlanAmountTypeEnum.concertEnumToMap();

            List<String> actualSalesList = ActualSalesAmountTypeEnum.concertEnumToList();
            Map<String, String> actualSalesMap = ActualSalesAmountTypeEnum.concertEnumToMap();

            if (StringUtils.isEmpty(code) || CalDataFromEnum.SALES_GOAL.getCode().equals(code)) {
                salesGoalList.forEach(salesGoal -> {
                    CommonSelectVo commonSelectVo = new CommonSelectVo();
                    commonSelectVo.setCode(salesGoal);
                    commonSelectVo.setValue(salesGoalMap.get(salesGoal));
                    commonSelectVoList.add(commonSelectVo);
                });
            }
            if (StringUtils.isEmpty(code) || CalDataFromEnum.SALES_PLAN.getCode().equals(code)) {
                salesPlanList.forEach(salesPlan -> {
                    CommonSelectVo commonSelectVo = new CommonSelectVo();
                    commonSelectVo.setCode(salesPlan);
                    commonSelectVo.setValue(salesPlanMap.get(salesPlan));
                    commonSelectVoList.add(commonSelectVo);
                });
            }
            if (StringUtils.isEmpty(code) || CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode().equals(code)) {
                actualSalesList.forEach(actualSales -> {
                    CommonSelectVo commonSelectVo = new CommonSelectVo();
                    commonSelectVo.setCode(actualSales);
                    commonSelectVo.setValue(actualSalesMap.get(actualSales));
                    commonSelectVoList.add(commonSelectVo);
                });
            }

            return commonSelectVoList;
        }
    }
}
