/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.cache;

import com.biz.crm.business.common.sdk.dto.UuidDto;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.MnPageCacheHelper;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigProductRatioEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.BudgetCalConfigProductRatioRepository;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigProductRatioDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class BudgetCalConfigProductRatioCacheHelper
extends MnPageCacheHelper<BudgetCalConfigProductRatioVo, BudgetCalConfigProductRatioDto> {
    private static final Logger log = LoggerFactory.getLogger(BudgetCalConfigProductRatioCacheHelper.class);
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private BudgetCalConfigProductRatioRepository budgetCalConfigProductRatioRepository;
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public String getCacheKeyPrefix() {
        return "tpm_budget_cal_config_product_ratio_key:";
    }

    public Class<BudgetCalConfigProductRatioDto> getDtoClass() {
        return BudgetCalConfigProductRatioDto.class;
    }

    public Class<BudgetCalConfigProductRatioVo> getVoClass() {
        return BudgetCalConfigProductRatioVo.class;
    }

    public List<BudgetCalConfigProductRatioDto> findDtoListFromRepository(BudgetCalConfigProductRatioDto dto, String cacheKey) {
        String budgetCalCode = dto.getBudgetCalCode();
        if (!StringUtils.hasText((String)budgetCalCode)) {
            return null;
        }
        List<BudgetCalConfigProductRatioEntity> entities = this.budgetCalConfigProductRatioRepository.listByCalConfigCode(dto);
        List ratioDtos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, BudgetCalConfigProductRatioEntity.class, BudgetCalConfigProductRatioDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)ratioDtos)) {
            ratioDtos.forEach(o -> {
                if (StringUtil.isBlank((CharSequence)o.getReduceTag())) {
                    o.setReduceTag(BooleanEnum.FALSE.getCapital());
                }
            });
            String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
            String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
            ratioDtos.forEach(o -> o.setId(cacheKey + "-" + o.getProductCode()));
            Map ratioDtoMap = ratioDtos.stream().collect(Collectors.toMap(UuidDto::getId, Function.identity()));
            this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), ratioDtoMap.keySet().toArray());
            this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, ratioDtoMap);
            this.redisService.expire(redisCacheDataKey, this.getExpireTime());
        }
        return ratioDtos;
    }

    public boolean initToCacheFromRepository() {
        return false;
    }

    public List<BudgetCalConfigProductRatioDto> newItem(String cacheKey, List<BudgetCalConfigProductRatioDto> itemList) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        List<BudgetCalConfigProductRatioDto> newList = itemList.stream().filter(item -> !idList.contains(cacheKey + "-" + item.getProductCode())).collect(Collectors.toList());
        Assert.notEmpty(newList, (String)"\u6dfb\u52a0\u7684\u6570\u636e\u5168\u90e8\u91cd\u590d");
        newList.forEach(dto -> {
            dto.setId(cacheKey + "-" + dto.getProductCode());
            dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            dto.setTenantCode(TenantUtils.getTenantCode());
            dto.setReduceTag(BooleanEnum.FALSE.getCapital());
        });
        return newList;
    }

    public void updateItem(String cacheKey, List<BudgetCalConfigProductRatioDto> itemList) {
    }

    public List<BudgetCalConfigProductRatioDto> copyItem(String cacheKey, List<BudgetCalConfigProductRatioDto> itemList) {
        return null;
    }

    public Object getDtoKey(BudgetCalConfigProductRatioDto budgetCalConfigProductRatioDto) {
        return budgetCalConfigProductRatioDto.getId();
    }

    public String getCheckedStatus(BudgetCalConfigProductRatioDto budgetCalConfigProductRatioDto) {
        return budgetCalConfigProductRatioDto.getChecked();
    }

    public void importSave(String cacheKey, BudgetCalConfigProductRatioDto dto) {
        String redisCacheIdKey = this.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.getRedisCacheDataKey(cacheKey);
        dto.setId(cacheKey + "-" + dto.getProductCode());
        List idList = this.redisService.lRange(redisCacheIdKey, 0L, -1L);
        if (!idList.contains(dto.getId())) {
            Object[] newIdArr = new Object[]{dto.getId()};
            this.redisService.lPushAll(redisCacheIdKey, Long.valueOf(this.getExpireTime()), newIdArr);
        }
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setTenantCode(TenantUtils.getTenantCode());
        HashMap ratioDtoMap = Maps.newHashMap();
        ratioDtoMap.put(dto.getId(), dto);
        this.redisTemplate.opsForHash().putAll((Object)redisCacheDataKey, (Map)ratioDtoMap);
        this.redisService.expire(redisCacheDataKey, this.getExpireTime());
    }
}

