/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/budget/cal/config"})
@Api(tags={"\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e"})
public class BudgetCalConfigController {
    private static final Logger log = LoggerFactory.getLogger(BudgetCalConfigController.class);
    @Autowired(required=false)
    private BudgetCalConfigService budgetCalConfigService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<BudgetCalConfigVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="budgetCalConfigDto", value="\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e") BudgetCalConfigDto dto) {
        try {
            Page page = this.budgetCalConfigService.findByConditions(pageable, dto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"detail"})
    public Result<BudgetCalConfigVo> detail(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            BudgetCalConfigVo budgetCalConfigVo = this.budgetCalConfigService.findById(id);
            return Result.ok((Object)budgetCalConfigVo);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @PostMapping(value={"listByConditions"})
    public Result<List<BudgetCalConfigVo>> listByConditions(@RequestBody BudgetCalConfigDto dto) {
        try {
            List result = this.budgetCalConfigService.listByConditions(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<BudgetCalConfigVo> create(@ApiParam(name="budgetItemDto", value="TPM-\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e") @RequestBody BudgetCalConfigDto dto) {
        try {
            BudgetCalConfigVo result = this.budgetCalConfigService.create(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<BudgetCalConfigVo> update(@ApiParam(name="budgetItemDto", value="TPM-\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e") @RequestBody BudgetCalConfigDto dto) {
        try {
            BudgetCalConfigVo result = this.budgetCalConfigService.update(dto);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @DeleteMapping
    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    public Result<?> delete(@RequestParam(value="ids") List<String> ids) {
        try {
            this.budgetCalConfigService.delete(ids);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6839\u636eid\u542f\u7528")
    @PatchMapping(value={"enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.budgetCalConfigService.enable(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u6839\u636eid\u7981\u7528")
    @PatchMapping(value={"disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.budgetCalConfigService.disable(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u9884\u7b97\u7c7b\u578b\u67e5\u8be2\u8ba1\u7b97\u914d\u7f6e\u7684\u6570\u636e\u6765\u6e90")
    @GetMapping(value={"listSelectByBudget"})
    public Result<List<CommonSelectVo>> listSelectByBudget(@RequestParam(value="budgetType", required=false) String budgetType) {
        try {
            List commonSelectVoList = this.budgetCalConfigService.listSelect(BooleanEnum.TRUE.getCapital(), budgetType);
            return Result.ok((Object)commonSelectVoList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u6765\u6e90\u67e5\u8be2\u8ba1\u7b97\u914d\u7f6e\u7684\u6570\u636e\u6765\u6e90")
    @GetMapping(value={"listSelectByDataFrom"})
    public Result<List<CommonSelectVo>> listSelectByDataFrom(@RequestParam(value="dataFrom", required=false) String dataFrom) {
        try {
            List commonSelectVoList = this.budgetCalConfigService.listSelect(BooleanEnum.FALSE.getCapital(), dataFrom);
            return Result.ok((Object)commonSelectVoList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

