/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.imports;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.util.ExceptionStackMsgUtil;
import com.biz.crm.tpm.business.budget.cal.config.local.cache.BudgetCalConfigProductRatioCacheHelper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigProductRatioDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioImportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Component
public class BudgetCalConfigProductRatioImportProcess
implements ImportProcess<BudgetCalConfigProductRatioImportVo> {
    private static final Logger log = LoggerFactory.getLogger(BudgetCalConfigProductRatioImportProcess.class);
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Resource
    private DictDataVoService dictDataVoService;
    @Resource
    private ProductVoService productVoService;
    @Resource
    private BudgetCalConfigProductRatioCacheHelper budgetCalConfigProductRatioCacheHelper;
    private Map<String, List<DictDataVo>> dictMap = Maps.newHashMap();

    @Transactional(rollbackFor={Exception.class})
    public Map<Integer, String> execute(LinkedHashMap<Integer, BudgetCalConfigProductRatioImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        Optional<BudgetCalConfigProductRatioImportVo> first = data.values().stream().findFirst();
        if (!first.isPresent()) {
            return null;
        }
        BudgetCalConfigProductRatioImportVo vo = first.get();
        try {
            BudgetCalConfigProductRatioDto dto = this.validate(vo);
            String cacheKey = String.valueOf(params.get("cacheKey"));
            Assert.hasText((String)cacheKey, (String)"cacheKey\u4e0d\u80fd\u4e3a\u7a7a");
            this.budgetCalConfigProductRatioCacheHelper.importSave(cacheKey, dto);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            String error = ExceptionStackMsgUtil.stackMsg((Exception)e);
            log.error("\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u5bfc\u5165\u5f02\u5e38:{}", (Object)error);
            throw new IllegalArgumentException("\u5bfc\u5165\u5f02\u5e38[" + error + "]");
        }
        return null;
    }

    private void initDict() {
        this.dictMap = this.dictDataVoService.findByDictTypeCodeList((List)Lists.newArrayList());
    }

    private BudgetCalConfigProductRatioDto validate(BudgetCalConfigProductRatioImportVo vo) {
        this.verifyEmpty(vo);
        String productCode = vo.getProductCode();
        List productVos = this.productVoService.findByCodes((List)Lists.newArrayList((Object[])new String[]{productCode}));
        Assert.notEmpty((Collection)productVos, (String)"\u672a\u67e5\u8be2\u5230\u5546\u54c1\u4fe1\u606f");
        ProductVo productVo = (ProductVo)productVos.get(0);
        if (StringUtils.isNotBlank((CharSequence)vo.getReduceTag())) {
            if (BooleanEnum.FALSE.getSure().equals(vo.getReduceTag())) {
                vo.setReduceTag(BooleanEnum.FALSE.getCapital());
            } else if (BooleanEnum.TRUE.getSure().equals(vo.getReduceTag())) {
                vo.setReduceTag(BooleanEnum.TRUE.getCapital());
            } else {
                Validate.isTrue((boolean)false, (String)"\u662f\u5426\u6263\u51cf\u65e0\u6cd5\u8bc6\u522b", (Object[])new Object[0]);
            }
        } else {
            vo.setReduceTag(BooleanEnum.FALSE.getCapital());
        }
        BudgetCalConfigProductRatioDto dto = new BudgetCalConfigProductRatioDto();
        dto.setId(productVo.getId());
        dto.setChargedRatio(vo.getChargedRatio());
        dto.setProductCode(productVo.getProductCode());
        dto.setProductName(productVo.getProductName());
        dto.setProductBrandCode(productVo.getProductBrandCode());
        dto.setProductBrandName(productVo.getProductBrandName());
        dto.setProductCategoryCode(productVo.getProductCategoryCode());
        dto.setProductCategoryName(productVo.getProductCategoryName());
        dto.setProductItemCode(productVo.getProductLevelCode());
        dto.setProductItemName(productVo.getProductLevelName());
        dto.setReduceTag(vo.getReduceTag());
        return dto;
    }

    private void verifyDictCode(BudgetCalConfigProductRatioImportVo vo) {
    }

    private void verifyEmpty(BudgetCalConfigProductRatioImportVo vo) {
        Assert.hasText((String)vo.getProductCode(), (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)vo.getChargedRatio(), (String)"\u8ba1\u8d39\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private String findDictValue(String dictValue, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictValue().equals(dictValue)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    private String findDictCode(String dictCode, String typeCode) {
        DictDataVo dictDataVo = this.dictMap.get(typeCode).stream().filter(a -> a.getDictCode().equals(dictCode)).findFirst().orElse(null);
        if (!ObjectUtils.isEmpty((Object)dictDataVo)) {
            return dictDataVo.getDictCode();
        }
        return null;
    }

    public Integer getBatchCount() {
        return 1;
    }

    public Class<BudgetCalConfigProductRatioImportVo> findCrmExcelVoClass() {
        return BudgetCalConfigProductRatioImportVo.class;
    }

    public String getTemplateCode() {
        return "TPM_BUDGET_CAL_CONFIG_PRODUCT_RATIO_IMPORT";
    }

    public String getTemplateName() {
        return "TPM-\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e\u4ea7\u54c1\u6bd4\u4f8b\u5bfc\u5165\u6a21\u7248";
    }

    public String getBusinessCode() {
        return "TPM_BUDGET_CAL_CONFIG_IMPORT";
    }

    public String getBusinessName() {
        return "TPM-\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e\u5bfc\u5165";
    }
}

