/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigAreaEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigAreaMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalAreaTypeEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetCalConfigAreaRepository
extends ServiceImpl<BudgetCalConfigAreaMapper, BudgetCalConfigAreaEntity> {
    public List<BudgetCalConfigAreaEntity> listByCalConfigCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return Arrays.asList(new BudgetCalConfigAreaEntity[0]);
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigAreaEntity::getBudgetCalCode, (Object)budgetCalCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void delByBudgetCalCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigAreaEntity::getBudgetCalCode, (Object)budgetCalCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigAreaEntity -> budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCodeList)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigAreaEntity -> budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public Integer listByCalCodesAndItemCodes(List<String> budgetCalCodeList, List<String> itemCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList) || CollectionUtils.isEmpty(itemCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(BudgetCalConfigAreaEntity::getAreaTypeCode, (Object)CalAreaTypeEnum.BUDGET_ITEM.getCode())).in(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCodeList)).in(BudgetCalConfigAreaEntity::getDataCode, itemCodeList)).count();
    }

    public List<BudgetCalConfigAreaEntity> listByCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(BudgetCalConfigAreaEntity::getAreaTypeCode, (Object)CalAreaTypeEnum.BUDGET_ITEM.getCode())).in(BudgetCalConfigAreaEntity::getBudgetCalCode, budgetCalCodeList)).list();
    }
}

