/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigDataEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigDataMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDataDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetCalConfigDataRepository
extends ServiceImpl<BudgetCalConfigDataMapper, BudgetCalConfigDataEntity> {
    public List<BudgetCalConfigDataEntity> listByCalConfigCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return Arrays.asList(new BudgetCalConfigDataEntity[0]);
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigDataEntity::getBudgetCalCode, (Object)budgetCalCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void delByBudgetCalCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigDataEntity::getBudgetCalCode, (Object)budgetCalCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigDataEntity -> budgetCalConfigDataEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetCalConfigDataEntity::getBudgetCalCode, budgetCalCodeList)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigDataEntity -> budgetCalConfigDataEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public List<BudgetCalConfigDataEntity> listByConditions(List<String> budgetCalCodeList, BudgetCalConfigDataDto data) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return null;
        }
        LambdaQueryChainWrapper eq = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetCalConfigDataEntity::getBudgetCalCode, budgetCalCodeList)).eq(BudgetCalConfigDataEntity::getCalDataFromCode, (Object)data.getCalDataFromCode())).eq(BudgetCalConfigDataEntity::getAmountTypeCode, (Object)data.getAmountTypeCode())).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        if (StringUtils.isEmpty((CharSequence)data.getCustomerTypeCode())) {
            return ((LambdaQueryChainWrapper)eq.isNull(BudgetCalConfigDataEntity::getCustomerTypeCode)).list();
        }
        return ((LambdaQueryChainWrapper)eq.eq(BudgetCalConfigDataEntity::getCustomerTypeCode, (Object)data.getCustomerTypeCode())).list();
    }
}

