/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigSalesOrgEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigSalesOrgMapper;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigSalesOrgDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetCalConfigSalesOrgRepository
extends ServiceImpl<BudgetCalConfigSalesOrgMapper, BudgetCalConfigSalesOrgEntity> {
    public void delByBudgetCalCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, (Object)budgetCalCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigSalesOrgEntity -> budgetCalConfigSalesOrgEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCodeList)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigSalesOrgEntity -> budgetCalConfigSalesOrgEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public List<BudgetCalConfigSalesOrgEntity> listByCalConfigCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return Lists.newArrayList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, (Object)budgetCalCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public List<BudgetCalConfigSalesOrgEntity> listByConditions(List<String> budgetCalCodeList, BudgetCalConfigSalesOrgDto data) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return null;
        }
        LambdaQueryChainWrapper eq = (LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCodeList)).eq(BudgetCalConfigSalesOrgEntity::getSalesOrgCode, (Object)data.getSalesOrgCode());
        return eq.list();
    }

    public Integer listByCalCodesAndSalesOrgCodes(List<String> budgetCalCodeList, List<String> salesOrgCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList) || CollectionUtils.isEmpty(salesOrgCodeList)) {
            return null;
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(BudgetCalConfigSalesOrgEntity::getBudgetCalCode, budgetCalCodeList)).in(BudgetCalConfigSalesOrgEntity::getSalesOrgCode, salesOrgCodeList)).count();
    }
}

