/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigScopeProductEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigScopeProductMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BudgetCalConfigScopeProductRepository
extends ServiceImpl<BudgetCalConfigScopeProductMapper, BudgetCalConfigScopeProductEntity> {
    public List<BudgetCalConfigScopeProductEntity> listByCalConfigCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return Arrays.asList(new BudgetCalConfigScopeProductEntity[0]);
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigScopeProductEntity::getBudgetCalCode, (Object)budgetCalCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).list();
    }

    public void delByBudgetCalCode(String budgetCalCode) {
        if (StringUtils.isEmpty((CharSequence)budgetCalCode)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BudgetCalConfigScopeProductEntity::getBudgetCalCode, (Object)budgetCalCode)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigAreaEntity -> budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }

    public void delByBudgetCalCodes(List<String> budgetCalCodeList) {
        if (CollectionUtils.isEmpty(budgetCalCodeList)) {
            return;
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BudgetCalConfigScopeProductEntity::getBudgetCalCode, budgetCalCodeList)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(budgetCalConfigAreaEntity -> budgetCalConfigAreaEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
            this.updateBatchById(list);
        }
    }
}

