/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mn.common.page.cache.service.internal.MnPageCacheServiceImpl;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigProductRatioDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigProductRatioService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="budgetCalConfigProductRatioService")
public class BudgetCalConfigProductRatioServiceImpl
extends MnPageCacheServiceImpl<BudgetCalConfigProductRatioVo, BudgetCalConfigProductRatioDto>
implements BudgetCalConfigProductRatioService {
    private static final Logger log = LoggerFactory.getLogger(BudgetCalConfigProductRatioServiceImpl.class);
    @Autowired(required=false)
    private RedisService redisService;
    @Autowired(required=false)
    private RedisTemplate<String, Object> redisTemplate;

    public Page<BudgetCalConfigProductRatioVo> findCachePageList(Pageable pageable, BudgetCalConfigProductRatioDto dto, String cacheKey) {
        String redisCacheIdKey = this.helper.getRedisCacheIdKey(cacheKey);
        String redisCacheDataKey = this.helper.getRedisCacheDataKey(cacheKey);
        String redisCacheInitKey = this.helper.getRedisCacheInitKey(cacheKey);
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        page.setTotal(0L);
        page.setRecords((List)Lists.newArrayList());
        if (this.redisService.hasKey(redisCacheIdKey).booleanValue()) {
            Long total = this.redisService.lSize(redisCacheIdKey);
            page.setTotal(total.longValue());
            List idList = this.redisService.lRange(redisCacheIdKey, page.offset(), page.offset() + page.getSize() - 1L);
            if (!CollectionUtils.isEmpty((Collection)idList)) {
                List dataList = this.redisTemplate.opsForHash().multiGet((Object)redisCacheDataKey, (Collection)idList);
                String dataListJson = JSONArray.toJSONString((Object)dataList);
                List ratioDtos = JSONArray.parseArray((String)dataListJson, BudgetCalConfigProductRatioDto.class);
                List filterDto = ratioDtos.stream().filter(o -> (StringUtils.hasText((String)dto.getProductCode()) && o.getProductCode().contains(dto.getProductCode()) || !StringUtils.hasText((String)dto.getProductCode())) && (StringUtils.hasText((String)dto.getProductName()) && o.getProductName().contains(dto.getProductName()) || !StringUtils.hasText((String)dto.getProductName()))).collect(Collectors.toList());
                List voList = this.helper.dtoListToVoList(filterDto);
                page.setRecords(voList);
            }
        } else if (!this.redisService.hasKey(redisCacheInitKey).booleanValue() && null != dto) {
            this.redisService.set(redisCacheInitKey, (Object)BooleanEnum.TRUE, this.helper.getExpireTime());
            List dtoList = this.helper.findDtoListFromRepository((Object)dto, cacheKey);
            if (!CollectionUtils.isEmpty((Collection)dtoList)) {
                if (this.helper.initToCacheFromRepository()) {
                    this.helper.putCache(cacheKey, dtoList);
                }
                page.setTotal((long)dtoList.size());
                long start = page.offset();
                if (page.getTotal() > start) {
                    long end = page.offset() + page.getSize();
                    if (page.getTotal() < end) {
                        end = page.getTotal();
                    }
                    List recordDtoList = dtoList.subList((int)page.offset(), (int)end);
                    List voList = this.helper.dtoListToVoList(recordDtoList);
                    page.setRecords(voList);
                }
            }
        }
        this.helper.fillVoListProperties(page.getRecords());
        return page;
    }
}

