/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.budget.cal.config.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigAreaEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigDataEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigProductRatioEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigSalesOrgEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.entity.BudgetCalConfigScopeProductEntity;
import com.biz.crm.tpm.business.budget.cal.config.local.mapper.BudgetCalConfigMapper;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.BudgetCalConfigAreaRepository;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.BudgetCalConfigDataRepository;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.BudgetCalConfigProductRatioRepository;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.BudgetCalConfigRepository;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.BudgetCalConfigSalesOrgRepository;
import com.biz.crm.tpm.business.budget.cal.config.local.repository.BudgetCalConfigScopeProductRepository;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigAreaDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDataDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigLogEventDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigProductRatioDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigSalesOrgDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigScopeProductDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.ActualSalesAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.BudgetTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalAreaTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.CalDataFromEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesGoalAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesOrgAreaEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.eunm.SalesPlanAmountTypeEnum;
import com.biz.crm.tpm.business.budget.cal.config.sdk.event.BudgetCalConfigLogEventListener;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigProductRatioService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.service.BudgetCalConfigService;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigAreaVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigDataVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigSalesOrgVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigScopeProductVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BudgetCalConfigServiceImpl
implements BudgetCalConfigService {
    private static final Logger log = LoggerFactory.getLogger(BudgetCalConfigServiceImpl.class);
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private BudgetCalConfigMapper budgetCalConfigMapper;
    @Autowired(required=false)
    private BudgetCalConfigRepository budgetCalConfigRepository;
    @Autowired(required=false)
    private BudgetCalConfigDataRepository budgetCalConfigDataRepository;
    @Autowired(required=false)
    private BudgetCalConfigAreaRepository budgetCalConfigAreaRepository;
    @Autowired(required=false)
    private BudgetCalConfigSalesOrgRepository budgetCalConfigSalesOrgRepository;
    @Autowired(required=false)
    private BudgetCalConfigProductRatioRepository budgetCalConfigProductRatioRepository;
    @Autowired(required=false)
    private BudgetCalConfigScopeProductRepository budgetCalConfigScopeProductRepository;
    @Resource
    private BudgetCalConfigProductRatioService budgetCalConfigProductRatioService;
    private final int LENGTH = 30;

    public Page<BudgetCalConfigVo> findByConditions(Pageable pageable, BudgetCalConfigDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(dto)) {
            dto = new BudgetCalConfigDto();
        }
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.budgetCalConfigMapper.findByConditions((Page<BudgetCalConfigVo>)page, dto);
    }

    public BudgetCalConfigVo findById(String id) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        BudgetCalConfigEntity budgetCalConfigEntity = this.budgetCalConfigRepository.getById(id, DelFlagStatusEnum.NORMAL.getCode());
        Validate.notNull((Object)((Object)budgetCalConfigEntity), (String)"\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01", (Object[])new Object[0]);
        return this.buildVo(budgetCalConfigEntity);
    }

    private BudgetCalConfigVo buildVo(BudgetCalConfigEntity budgetCalConfigEntity) {
        if (Objects.isNull((Object)budgetCalConfigEntity)) {
            return null;
        }
        List<BudgetCalConfigSalesOrgEntity> salesOrgEntities = this.budgetCalConfigSalesOrgRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());
        List<BudgetCalConfigAreaEntity> areaEntities = this.budgetCalConfigAreaRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());
        List<BudgetCalConfigDataEntity> dataEntities = this.budgetCalConfigDataRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());
        String budgetCalCode = budgetCalConfigEntity.getBudgetCalCode();
        BudgetCalConfigProductRatioDto ratioDto = new BudgetCalConfigProductRatioDto();
        ratioDto.setBudgetCalCode(budgetCalCode);
        List<BudgetCalConfigProductRatioEntity> ratioEntities = this.budgetCalConfigProductRatioRepository.listByCalConfigCode(ratioDto);
        List<BudgetCalConfigScopeProductEntity> scopeProductEntities = this.budgetCalConfigScopeProductRepository.listByCalConfigCode(budgetCalConfigEntity.getBudgetCalCode());
        BudgetCalConfigVo budgetCalConfigVo = (BudgetCalConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetCalConfigEntity, BudgetCalConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        if (!CollectionUtils.isEmpty(salesOrgEntities)) {
            budgetCalConfigVo.setSalesOrgList(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(salesOrgEntities, BudgetCalConfigSalesOrgEntity.class, BudgetCalConfigSalesOrgVo.class, LinkedHashSet.class, ArrayList.class, new String[0])));
        }
        if (!CollectionUtils.isEmpty(areaEntities)) {
            List customerList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.CUSTOMER.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            List productList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.PRODUCT.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            List terminalList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.TERMINAL.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            List budgetItemList = areaEntities.stream().filter(areaEntity -> CalAreaTypeEnum.BUDGET_ITEM.getCode().equals(areaEntity.getAreaTypeCode())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(customerList)) {
                budgetCalConfigVo.setCustomerList(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(customerList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            }
            if (!CollectionUtils.isEmpty(productList)) {
                budgetCalConfigVo.setProductList(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(productList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            }
            if (!CollectionUtils.isEmpty(terminalList)) {
                budgetCalConfigVo.setTerminalList(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(terminalList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class, new String[0])));
            }
            if (!CollectionUtils.isEmpty(budgetItemList)) {
                List budgetCalConfigAreaVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(budgetItemList, BudgetCalConfigAreaEntity.class, BudgetCalConfigAreaVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                if (!CollectionUtils.isEmpty(scopeProductEntities)) {
                    List budgetCalConfigScopeProductVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(scopeProductEntities, BudgetCalConfigScopeProductEntity.class, BudgetCalConfigScopeProductVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
                    Map<String, List<BudgetCalConfigScopeProductVo>> scopeProductMap = budgetCalConfigScopeProductVos.stream().collect(Collectors.groupingBy(BudgetCalConfigScopeProductVo::getConfigAreaId));
                    budgetCalConfigAreaVos.forEach(budgetCalConfigAreaVo -> {
                        List budgetCalConfigScopeProductEntities = (List)scopeProductMap.get(budgetCalConfigAreaVo.getId());
                        budgetCalConfigAreaVo.setScopeProducts(budgetCalConfigScopeProductEntities);
                    });
                }
                budgetCalConfigVo.setBudgetItemList(budgetCalConfigAreaVos);
            }
        }
        if (!CollectionUtils.isEmpty(dataEntities)) {
            budgetCalConfigVo.setDataList(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(dataEntities, BudgetCalConfigDataEntity.class, BudgetCalConfigDataVo.class, LinkedHashSet.class, ArrayList.class, new String[0])));
        }
        if (!CollectionUtils.isEmpty(ratioEntities)) {
            budgetCalConfigVo.setProductRatios(new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(ratioEntities, BudgetCalConfigProductRatioEntity.class, BudgetCalConfigProductRatioVo.class, LinkedHashSet.class, ArrayList.class, new String[0])));
        }
        return budgetCalConfigVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetCalConfigVo create(BudgetCalConfigDto dto) {
        String cacheKey;
        this.createValidate(dto);
        BudgetCalConfigEntity budgetCalConfigEntity = (BudgetCalConfigEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetCalConfigEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.budgetCalConfigRepository.saveOrUpdate((Object)budgetCalConfigEntity);
        if (!CollectionUtils.isEmpty((Collection)dto.getSalesOrgList())) {
            ArrayList budgetCalConfigSalesOrgEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getSalesOrgList(), BudgetCalConfigSalesOrgDto.class, BudgetCalConfigSalesOrgEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            budgetCalConfigSalesOrgEntities.forEach(o -> o.setId(null));
            this.budgetCalConfigSalesOrgRepository.saveBatch(budgetCalConfigSalesOrgEntities);
        }
        ArrayList budgetCalConfigAreaDtoList = new ArrayList();
        budgetCalConfigAreaDtoList.addAll(dto.getCustomerList());
        budgetCalConfigAreaDtoList.addAll(dto.getProductList());
        budgetCalConfigAreaDtoList.addAll(dto.getTerminalList());
        if (!CollectionUtils.isEmpty(budgetCalConfigAreaDtoList)) {
            ArrayList budgetCalConfigAreaEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList(budgetCalConfigAreaDtoList, BudgetCalConfigAreaDto.class, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            budgetCalConfigAreaEntities.forEach(o -> o.setId(null));
            this.budgetCalConfigAreaRepository.saveBatch(budgetCalConfigAreaEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getBudgetItemList())) {
            dto.getBudgetItemList().forEach(budgetCalConfigAreaDto -> {
                BudgetCalConfigAreaEntity budgetCalConfigAreaEntity = (BudgetCalConfigAreaEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(budgetCalConfigAreaDto, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
                budgetCalConfigAreaEntity.setId(null);
                this.budgetCalConfigAreaRepository.save((Object)budgetCalConfigAreaEntity);
                if (!CollectionUtils.isEmpty((Collection)budgetCalConfigAreaDto.getScopeProducts())) {
                    ArrayList entities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)budgetCalConfigAreaDto.getScopeProducts(), BudgetCalConfigScopeProductDto.class, BudgetCalConfigScopeProductEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                    entities.forEach(budgetCalConfigScopeProductEntity -> {
                        budgetCalConfigScopeProductEntity.setId(null);
                        budgetCalConfigScopeProductEntity.setConfigAreaId(budgetCalConfigAreaEntity.getId());
                    });
                    this.budgetCalConfigScopeProductRepository.saveBatch(entities);
                }
            });
        }
        if (StringUtils.hasText((String)(cacheKey = dto.getCacheKey()))) {
            List ratioDtos = this.budgetCalConfigProductRatioService.findCacheList(cacheKey);
            if (!CollectionUtils.isEmpty((Collection)ratioDtos)) {
                for (int i = 0; i < ratioDtos.size(); ++i) {
                    ((BudgetCalConfigProductRatioDto)ratioDtos.get(i)).setIndexNo(Integer.valueOf(i + 1));
                    if (((BudgetCalConfigProductRatioDto)ratioDtos.get(i)).getChargedRatio() != null) continue;
                    throw new RuntimeException("\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u5217\u7b2c" + (i + 1) + "\u884c\u8ba1\u8d39\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            dto.setProductRatioVos(ratioDtos);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getProductRatioVos())) {
            ArrayList budgetCalConfigProductRatioEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getProductRatioVos(), BudgetCalConfigProductRatioDto.class, BudgetCalConfigProductRatioEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            budgetCalConfigProductRatioEntities.forEach(o -> o.setBudgetCalCode(budgetCalConfigEntity.getBudgetCalCode()));
            this.budgetCalConfigProductRatioRepository.saveBatch(budgetCalConfigProductRatioEntities);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getDataList())) {
            ArrayList budgetCalConfigDataEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getDataList(), BudgetCalConfigDataDto.class, BudgetCalConfigDataEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            budgetCalConfigDataEntities.forEach(o -> o.setId(null));
            this.budgetCalConfigDataRepository.saveBatch(budgetCalConfigDataEntities);
        }
        BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onCreate = BudgetCalConfigLogEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetCalConfigLogEventListener.class, (SerializableBiConsumer)onCreate);
        return (BudgetCalConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetCalConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidate(BudgetCalConfigDto dto) {
        List collect;
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBudgetCalName(), (String)"\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBudgetTypeCode(), (String)"\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
            Validate.notEmpty((CharSequence)dto.getGroupCode(), (String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notNull((Object)dto.getEffectBeginTime(), (String)"\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEffectEndTime(), (String)"\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (dto.getEffectBeginTime().after(dto.getEffectEndTime())) {
            throw new RuntimeException("\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e");
        }
        Validate.notEmpty((Collection)dto.getDataList(), (String)"\u6570\u636e\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (BudgetTypeEnum.YEAR_BUDGET.getCode().equals(dto.getBudgetTypeCode()) && !CollectionUtils.isEmpty(collect = dto.getDataList().stream().filter(data -> !CalDataFromEnum.SALES_GOAL.getCode().equals(data.getCalDataFromCode())).collect(Collectors.toList()))) {
            throw new RuntimeException("\u5e74\u5ea6\u9884\u7b97\u7684\u6570\u636e\u6765\u6e90\u53ea\u80fd\u7ef4\u62a4\u9500\u552e\u4efb\u52a1\uff01");
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        dto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        dto.setBudgetCalCode((String)this.generateCodeService.generateCode("JSPZ", 1, Integer.valueOf(6), 2L, TimeUnit.DAYS).get(0));
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(dto.getOrgAreaCode()) && CollectionUtils.isEmpty((Collection)dto.getSalesOrgList())) {
            throw new RuntimeException("\u5305\u542b\u7ec4\u7ec7\u4e3a\u81ea\u5b9a\u7ec4\u7ec7\uff0c\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getSalesOrgList())) {
            dto.getSalesOrgList().forEach(salesOrg -> {
                Validate.notEmpty((CharSequence)salesOrg.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)salesOrg.getSalesOrgName(), (String)"\u9500\u552e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                salesOrg.setId(null);
                salesOrg.setTenantCode(TenantUtils.getTenantCode());
                salesOrg.setBudgetCalCode(dto.getBudgetCalCode());
                salesOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                salesOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getCustomerList())) {
            dto.getCustomerList().forEach(customer -> {
                Validate.notEmpty((CharSequence)customer.getDataCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)customer.getDataName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                customer.setId(null);
                customer.setTenantCode(TenantUtils.getTenantCode());
                customer.setBudgetCalCode(dto.getBudgetCalCode());
                customer.setAreaTypeCode(CalAreaTypeEnum.CUSTOMER.getCode());
                customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getProductList())) {
            dto.getProductList().forEach(product -> {
                Validate.notEmpty((CharSequence)product.getDataCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)product.getDataName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                product.setId(null);
                product.setTenantCode(TenantUtils.getTenantCode());
                product.setBudgetCalCode(dto.getBudgetCalCode());
                product.setAreaTypeCode(CalAreaTypeEnum.PRODUCT.getCode());
                product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getTerminalList())) {
            dto.getTerminalList().forEach(terminal -> {
                Validate.notEmpty((CharSequence)terminal.getDataCode(), (String)"\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)terminal.getDataName(), (String)"\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                terminal.setId(null);
                terminal.setTenantCode(TenantUtils.getTenantCode());
                terminal.setBudgetCalCode(dto.getBudgetCalCode());
                terminal.setAreaTypeCode(CalAreaTypeEnum.TERMINAL.getCode());
                terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getBudgetItemList())) {
            dto.getBudgetItemList().forEach(budgetItem -> {
                Validate.notEmpty((CharSequence)budgetItem.getDataCode(), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)budgetItem.getDataName(), (String)"\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                budgetItem.setId(null);
                budgetItem.setTenantCode(TenantUtils.getTenantCode());
                budgetItem.setBudgetCalCode(dto.getBudgetCalCode());
                budgetItem.setAreaTypeCode(CalAreaTypeEnum.BUDGET_ITEM.getCode());
                budgetItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                if (!CollectionUtils.isEmpty((Collection)budgetItem.getScopeProducts())) {
                    budgetItem.getScopeProducts().forEach(budgetCalConfigScopeProductDto -> {
                        Validate.notEmpty((CharSequence)budgetCalConfigScopeProductDto.getProductCode(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                        Validate.notEmpty((CharSequence)budgetCalConfigScopeProductDto.getProductName(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                        budgetCalConfigScopeProductDto.setId(null);
                        budgetCalConfigScopeProductDto.setTenantCode(TenantUtils.getTenantCode());
                        budgetCalConfigScopeProductDto.setBudgetCalCode(dto.getBudgetCalCode());
                        budgetCalConfigScopeProductDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    });
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getProductRatioVos())) {
            dto.getProductRatioVos().forEach(budgetCalConfigProductRatioDto -> {
                Validate.notEmpty((CharSequence)budgetCalConfigProductRatioDto.getProductCode(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)budgetCalConfigProductRatioDto.getProductName(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                budgetCalConfigProductRatioDto.setId(null);
                budgetCalConfigProductRatioDto.setTenantCode(TenantUtils.getTenantCode());
                budgetCalConfigProductRatioDto.setBudgetCalCode(dto.getBudgetCalCode());
                budgetCalConfigProductRatioDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByConditions(dto);
        AtomicReference<Boolean> dataB = new AtomicReference<Boolean>(false);
        dto.getDataList().forEach(data -> {
            List<String> budgetCalCodeList;
            List<BudgetCalConfigDataEntity> budgetCalConfigDataEntityList;
            Validate.notEmpty((CharSequence)data.getCalDataFromCode(), (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)data.getAmountTypeCode(), (String)"\u91d1\u989d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            data.setId(null);
            data.setTenantCode(TenantUtils.getTenantCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            data.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            if (!CollectionUtils.isEmpty((Collection)budgetCalConfigEntities) && !CollectionUtils.isEmpty(budgetCalConfigDataEntityList = this.budgetCalConfigDataRepository.listByConditions(budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList()), (BudgetCalConfigDataDto)data))) {
                dataB.set(true);
            }
        });
        if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
            if (dataB.get().booleanValue()) {
                if (!CollectionUtils.isEmpty((Collection)dto.getBudgetItemList())) {
                    List<String> itemCodeList = dto.getBudgetItemList().stream().map(BudgetCalConfigAreaDto::getDataCode).collect(Collectors.toList());
                    Integer count = this.budgetCalConfigAreaRepository.listByCalCodesAndItemCodes(budgetCalCodeList, itemCodeList);
                    if (!Objects.isNull(count) && count > 0) {
                        throw new RuntimeException("\u9884\u7b97\u8ba1\u7b97\u57fa\u672c\u4fe1\u606f+\u9884\u7b97\u8303\u56f4+\u6570\u636e\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                } else {
                    List<BudgetCalConfigAreaEntity> entities = this.budgetCalConfigAreaRepository.listByCalCodes(budgetCalCodeList);
                    if (CollectionUtils.isEmpty(entities)) {
                        throw new RuntimeException("\u9884\u7b97\u8ba1\u7b97\u57fa\u672c\u4fe1\u606f+\u6570\u636e\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    List calCodes = entities.stream().map(BudgetCalConfigAreaEntity::getBudgetCalCode).distinct().collect(Collectors.toList());
                    budgetCalCodeList.removeAll(calCodes);
                    if (!CollectionUtils.isEmpty(budgetCalCodeList)) {
                        throw new RuntimeException("\u9884\u7b97\u8ba1\u7b97\u57fa\u672c\u4fe1\u606f+\u6570\u636e\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetCalConfigVo update(BudgetCalConfigDto dto) {
        this.updateValidate(dto);
        BudgetCalConfigVo budgetCalConfigVo = this.findById(dto.getId());
        if (ObjectUtils.isEmpty((Object)budgetCalConfigVo)) {
            throw new RuntimeException("\u4fee\u6539\u6570\u636e\u5931\u8d25\uff0c\u539f\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if (dto.getBudgetCalName().length() > 30) {
            throw new IllegalArgumentException("\u9884\u7b97\u8ba1\u7b97\u540d\u79f0\u8fc7\u957f");
        }
        BudgetCalConfigDto oldVo = (BudgetCalConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetCalConfigVo, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        BudgetCalConfigEntity budgetCalConfigEntity = (BudgetCalConfigEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetCalConfigEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.budgetCalConfigRepository.updateById((Object)budgetCalConfigEntity);
        this.budgetCalConfigSalesOrgRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        if (!CollectionUtils.isEmpty((Collection)dto.getSalesOrgList())) {
            Collection budgetCalConfigSalesOrgEntities = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getSalesOrgList(), BudgetCalConfigSalesOrgDto.class, BudgetCalConfigSalesOrgEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            budgetCalConfigSalesOrgEntities.forEach(o -> o.setId(null));
            this.budgetCalConfigSalesOrgRepository.saveBatch(new ArrayList(budgetCalConfigSalesOrgEntities));
        }
        this.budgetCalConfigAreaRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        this.budgetCalConfigScopeProductRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        ArrayList areaList = new ArrayList();
        areaList.addAll(dto.getCustomerList());
        areaList.addAll(dto.getProductList());
        areaList.addAll(dto.getTerminalList());
        if (!CollectionUtils.isEmpty(areaList)) {
            Collection budgetCalConfigAreaEntities = this.nebulaToolkitService.copyCollectionByBlankList(areaList, BudgetCalConfigAreaDto.class, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            budgetCalConfigAreaEntities.forEach(o -> o.setId(null));
            this.budgetCalConfigAreaRepository.saveBatch(new ArrayList(budgetCalConfigAreaEntities));
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getBudgetItemList())) {
            dto.getBudgetItemList().forEach(budgetCalConfigAreaDto -> {
                BudgetCalConfigAreaEntity budgetCalConfigAreaEntity = (BudgetCalConfigAreaEntity)((Object)((Object)this.nebulaToolkitService.copyObjectByWhiteList(budgetCalConfigAreaDto, BudgetCalConfigAreaEntity.class, LinkedHashSet.class, ArrayList.class, new String[0])));
                budgetCalConfigAreaEntity.setId(null);
                this.budgetCalConfigAreaRepository.save((Object)budgetCalConfigAreaEntity);
                if (!CollectionUtils.isEmpty((Collection)budgetCalConfigAreaDto.getScopeProducts())) {
                    ArrayList entities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)budgetCalConfigAreaDto.getScopeProducts(), BudgetCalConfigScopeProductDto.class, BudgetCalConfigScopeProductEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                    entities.forEach(budgetCalConfigScopeProductEntity -> {
                        budgetCalConfigScopeProductEntity.setId(null);
                        budgetCalConfigScopeProductEntity.setConfigAreaId(budgetCalConfigAreaEntity.getId());
                    });
                    this.budgetCalConfigScopeProductRepository.saveBatch(entities);
                }
            });
        }
        this.budgetCalConfigProductRatioRepository.delByBudgetCalCodes(Lists.newArrayList((Object[])new String[]{dto.getBudgetCalCode()}));
        String cacheKey = dto.getCacheKey();
        if (StringUtils.hasText((String)cacheKey)) {
            List ratioDtos = this.budgetCalConfigProductRatioService.findCacheList(cacheKey);
            if (!CollectionUtils.isEmpty((Collection)ratioDtos)) {
                for (int i = 0; i < ratioDtos.size(); ++i) {
                    ((BudgetCalConfigProductRatioDto)ratioDtos.get(i)).setIndexNo(Integer.valueOf(i + 1));
                    if (((BudgetCalConfigProductRatioDto)ratioDtos.get(i)).getChargedRatio() != null) continue;
                    throw new RuntimeException("\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u5217\u7b2c" + (i + 1) + "\u884c\u8ba1\u8d39\u70b9\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
            dto.setProductRatioVos(ratioDtos);
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getProductRatioVos())) {
            ArrayList budgetCalConfigProductRatioEntities = new ArrayList(this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getProductRatioVos(), BudgetCalConfigProductRatioDto.class, BudgetCalConfigProductRatioEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            budgetCalConfigProductRatioEntities.forEach(o -> o.setBudgetCalCode(budgetCalConfigEntity.getBudgetCalCode()));
            this.budgetCalConfigProductRatioRepository.saveBatch(budgetCalConfigProductRatioEntities);
        }
        this.budgetCalConfigDataRepository.delByBudgetCalCode(dto.getBudgetCalCode());
        if (!CollectionUtils.isEmpty((Collection)dto.getDataList())) {
            Collection budgetCalConfigDataEntities = this.nebulaToolkitService.copyCollectionByBlankList((Iterable)dto.getDataList(), BudgetCalConfigDataDto.class, BudgetCalConfigDataEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            budgetCalConfigDataEntities.forEach(o -> o.setId(null));
            this.budgetCalConfigDataRepository.saveBatch(budgetCalConfigDataEntities);
        }
        BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(dto);
        SerializableBiConsumer & Serializable onUpdate = BudgetCalConfigLogEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetCalConfigLogEventListener.class, (SerializableBiConsumer)onUpdate);
        return (BudgetCalConfigVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, BudgetCalConfigVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    private void updateValidate(BudgetCalConfigDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBudgetCalName(), (String)"\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBudgetTypeCode(), (String)"\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessFormatCode(), (String)"\u4e1a\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)dto.getBusinessUnitCode(), (String)"\u4e1a\u52a1\u5355\u5143\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (BusinessUnitEnum.isDefaultBusinessUnit((String)dto.getBusinessUnitCode())) {
            Validate.notEmpty((CharSequence)dto.getGroupCode(), (String)"\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        }
        Validate.notNull((Object)dto.getEffectBeginTime(), (String)"\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getEffectEndTime(), (String)"\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        if (dto.getEffectBeginTime().after(dto.getEffectEndTime())) {
            throw new RuntimeException("\u751f\u6548\u8d77\u59cb\u65f6\u95f4\u4e0d\u80fd\u5728\u751f\u6548\u7ed3\u675f\u65f6\u95f4\u4e4b\u540e");
        }
        Validate.notEmpty((Collection)dto.getDataList(), (String)"\u6570\u636e\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByConditions(dto);
        dto.setTenantCode(TenantUtils.getTenantCode());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        if (SalesOrgAreaEnum.CUSTOMIZE_ORG.getCode().equals(dto.getOrgAreaCode()) && CollectionUtils.isEmpty((Collection)dto.getSalesOrgList())) {
            throw new RuntimeException("\u5305\u542b\u7ec4\u7ec7\u4e3a\u81ea\u5b9a\u7ec4\u7ec7\uff0c\u9500\u552e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getSalesOrgList())) {
            dto.getSalesOrgList().forEach(salesOrg -> {
                Validate.notEmpty((CharSequence)salesOrg.getSalesOrgCode(), (String)"\u9500\u552e\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)salesOrg.getSalesOrgName(), (String)"\u9500\u552e\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                salesOrg.setTenantCode(TenantUtils.getTenantCode());
                salesOrg.setBudgetCalCode(dto.getBudgetCalCode());
                salesOrg.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                salesOrg.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getCustomerList())) {
            dto.getCustomerList().forEach(customer -> {
                Validate.notEmpty((CharSequence)customer.getDataCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)customer.getDataName(), (String)"\u5ba2\u6237\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                customer.setTenantCode(TenantUtils.getTenantCode());
                customer.setBudgetCalCode(dto.getBudgetCalCode());
                customer.setAreaTypeCode(CalAreaTypeEnum.CUSTOMER.getCode());
                customer.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getProductList())) {
            dto.getProductList().forEach(product -> {
                Validate.notEmpty((CharSequence)product.getDataCode(), (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)product.getDataName(), (String)"\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                product.setTenantCode(TenantUtils.getTenantCode());
                product.setBudgetCalCode(dto.getBudgetCalCode());
                product.setAreaTypeCode(CalAreaTypeEnum.PRODUCT.getCode());
                product.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getTerminalList())) {
            dto.getTerminalList().forEach(terminal -> {
                Validate.notEmpty((CharSequence)terminal.getDataCode(), (String)"\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)terminal.getDataName(), (String)"\u95e8\u5e97\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                terminal.setTenantCode(TenantUtils.getTenantCode());
                terminal.setBudgetCalCode(dto.getBudgetCalCode());
                terminal.setAreaTypeCode(CalAreaTypeEnum.TERMINAL.getCode());
                terminal.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getBudgetItemList())) {
            dto.getBudgetItemList().forEach(budgetItem -> {
                Validate.notEmpty((CharSequence)budgetItem.getDataCode(), (String)"\u9884\u7b97\u9879\u76ee\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)budgetItem.getDataName(), (String)"\u9884\u7b97\u9879\u76ee\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                budgetItem.setTenantCode(TenantUtils.getTenantCode());
                budgetItem.setBudgetCalCode(dto.getBudgetCalCode());
                budgetItem.setAreaTypeCode(CalAreaTypeEnum.BUDGET_ITEM.getCode());
                budgetItem.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                if (!CollectionUtils.isEmpty((Collection)budgetItem.getScopeProducts())) {
                    budgetItem.getScopeProducts().forEach(budgetCalConfigScopeProductDto -> {
                        Validate.notEmpty((CharSequence)budgetCalConfigScopeProductDto.getProductCode(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                        Validate.notEmpty((CharSequence)budgetCalConfigScopeProductDto.getProductName(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                        budgetCalConfigScopeProductDto.setTenantCode(TenantUtils.getTenantCode());
                        budgetCalConfigScopeProductDto.setBudgetCalCode(dto.getBudgetCalCode());
                        budgetCalConfigScopeProductDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                    });
                }
            });
        }
        if (!CollectionUtils.isEmpty((Collection)dto.getProductRatioVos())) {
            dto.getProductRatioVos().forEach(budgetCalConfigProductRatioDto -> {
                Validate.notEmpty((CharSequence)budgetCalConfigProductRatioDto.getProductCode(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                Validate.notEmpty((CharSequence)budgetCalConfigProductRatioDto.getProductName(), (String)"\u4ea7\u54c1\u8ba1\u8d39\u6bd4\u4f8b\u4ea7\u54c1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
                budgetCalConfigProductRatioDto.setTenantCode(TenantUtils.getTenantCode());
                budgetCalConfigProductRatioDto.setBudgetCalCode(dto.getBudgetCalCode());
                budgetCalConfigProductRatioDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            });
        }
        dto.getDataList().forEach(data -> {
            Validate.notEmpty((CharSequence)data.getCalDataFromCode(), (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)data.getAmountTypeCode(), (String)"\u91d1\u989d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            data.setTenantCode(TenantUtils.getTenantCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            data.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
        });
        AtomicReference<Boolean> dataB = new AtomicReference<Boolean>(false);
        dto.getDataList().forEach(data -> {
            List<String> budgetCalCodeList;
            List<BudgetCalConfigDataEntity> budgetCalConfigDataEntityList;
            Validate.notEmpty((CharSequence)data.getCalDataFromCode(), (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)data.getAmountTypeCode(), (String)"\u91d1\u989d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            data.setId(null);
            data.setTenantCode(TenantUtils.getTenantCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            data.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            data.setBudgetCalCode(dto.getBudgetCalCode());
            if (!CollectionUtils.isEmpty((Collection)budgetCalConfigEntities) && !CollectionUtils.isEmpty(budgetCalConfigDataEntityList = this.budgetCalConfigDataRepository.listByConditions(budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList()), (BudgetCalConfigDataDto)data))) {
                dataB.set(true);
            }
        });
        if (!CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
            if (dataB.get().booleanValue()) {
                if (!CollectionUtils.isEmpty((Collection)dto.getBudgetItemList())) {
                    List<String> itemCodeList = dto.getBudgetItemList().stream().map(BudgetCalConfigAreaDto::getDataCode).collect(Collectors.toList());
                    Integer count = this.budgetCalConfigAreaRepository.listByCalCodesAndItemCodes(budgetCalCodeList, itemCodeList);
                    if (!Objects.isNull(count) && count > 0) {
                        throw new RuntimeException("\u9884\u7b97\u8ba1\u7b97\u57fa\u672c\u4fe1\u606f+\u9884\u7b97\u8303\u56f4+\u6570\u636e\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                } else {
                    List<BudgetCalConfigAreaEntity> entities = this.budgetCalConfigAreaRepository.listByCalCodes(budgetCalCodeList);
                    if (CollectionUtils.isEmpty(entities)) {
                        throw new RuntimeException("\u9884\u7b97\u8ba1\u7b97\u57fa\u672c\u4fe1\u606f+\u6570\u636e\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                    List calCodes = entities.stream().map(BudgetCalConfigAreaEntity::getBudgetCalCode).distinct().collect(Collectors.toList());
                    budgetCalCodeList.removeAll(calCodes);
                    if (!CollectionUtils.isEmpty(budgetCalCodeList)) {
                        throw new RuntimeException("\u9884\u7b97\u8ba1\u7b97\u57fa\u672c\u4fe1\u606f+\u6570\u636e\u914d\u7f6e\u5b58\u5728\u76f8\u540c\u7ef4\u5ea6\uff0c\u8bf7\u68c0\u67e5\uff01");
                    }
                }
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u6570\u636e\uff01");
        }
        List budgetCalConfigEntities = this.budgetCalConfigRepository.listByIds(ids);
        if (CollectionUtils.isEmpty((Collection)budgetCalConfigEntities)) {
            return;
        }
        List<String> budgetCalCodeList = budgetCalConfigEntities.stream().map(BudgetCalConfigEntity::getBudgetCalCode).collect(Collectors.toList());
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> budgetCalConfigEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode()));
        this.budgetCalConfigRepository.updateBatchById(budgetCalConfigEntities);
        this.budgetCalConfigSalesOrgRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigDataRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigAreaRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigProductRatioRepository.delByBudgetCalCodes(budgetCalCodeList);
        this.budgetCalConfigScopeProductRepository.delByBudgetCalCodes(budgetCalCodeList);
        BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            logEventDto.setOriginal((BudgetCalConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetCalConfigEntity, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDelete = BudgetCalConfigLogEventListener::onDelete;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetCalConfigLogEventListener.class, (SerializableBiConsumer)onDelete);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u6570\u636e\uff01");
        }
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            return;
        }
        budgetCalConfigEntities.forEach(budgetItemEntity -> {
            if (EnableStatusEnum.ENABLE.getCode().equals(budgetItemEntity.getEnableStatus())) {
                throw new RuntimeException("\u542f\u7528\u5931\u8d25\uff0c\u53ea\u80fd\u9009\u62e9\u7981\u7528\u72b6\u6001\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e");
            }
            budgetItemEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        });
        this.budgetCalConfigRepository.updateBatchById(budgetCalConfigEntities);
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
            logEventDto.setOriginal((BudgetCalConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetCalConfigEntity, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onEnable = BudgetCalConfigLogEventListener::onEnable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetCalConfigLogEventListener.class, (SerializableBiConsumer)onEnable);
        });
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u6570\u636e");
        }
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByIds(ids, DelFlagStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            return;
        }
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            if (EnableStatusEnum.DISABLE.getCode().equals(budgetCalConfigEntity.getEnableStatus())) {
                throw new RuntimeException("\u7981\u7528\u5931\u8d25\uff0c\u53ea\u80fd\u9009\u62e9\u542f\u7528\u72b6\u6001\u9884\u7b97\u8ba1\u7b97\u914d\u7f6e");
            }
            budgetCalConfigEntity.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
        });
        this.budgetCalConfigRepository.updateBatchById(budgetCalConfigEntities);
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> {
            BudgetCalConfigLogEventDto logEventDto = new BudgetCalConfigLogEventDto();
            logEventDto.setOriginal((BudgetCalConfigDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)budgetCalConfigEntity, BudgetCalConfigDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
            logEventDto.setNewest(null);
            SerializableBiConsumer & Serializable onDisable = BudgetCalConfigLogEventListener::onDisable;
            this.nebulaNetEventClient.publish((NebulaEventDto)logEventDto, BudgetCalConfigLogEventListener.class, (SerializableBiConsumer)onDisable);
        });
    }

    public List<BudgetCalConfigVo> listByConditions(BudgetCalConfigDto budgetCalConfigDto) {
        List<BudgetCalConfigEntity> budgetCalConfigEntities = this.budgetCalConfigRepository.listByConditions(budgetCalConfigDto);
        if (CollectionUtils.isEmpty(budgetCalConfigEntities)) {
            return Lists.newArrayList();
        }
        ArrayList<BudgetCalConfigVo> result = new ArrayList<BudgetCalConfigVo>();
        budgetCalConfigEntities.forEach(budgetCalConfigEntity -> result.add(this.buildVo((BudgetCalConfigEntity)((Object)budgetCalConfigEntity))));
        return result;
    }

    public List<CommonSelectVo> listSelect(String type, String code) {
        ArrayList<CommonSelectVo> commonSelectVoList = new ArrayList<CommonSelectVo>();
        if (BooleanEnum.TRUE.getCapital().equals(type)) {
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)code) || BudgetTypeEnum.YEAR_BUDGET.getCode().equals(code)) {
                CommonSelectVo commonSelectVo = new CommonSelectVo();
                commonSelectVo.setCode(CalDataFromEnum.SALES_GOAL.getCode());
                commonSelectVo.setValue(CalDataFromEnum.SALES_GOAL.getDesc());
                commonSelectVoList.add(commonSelectVo);
            }
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)code) || BudgetTypeEnum.MONTH_BUDGET.getCode().equals(code)) {
                CommonSelectVo planSelectVo = new CommonSelectVo();
                planSelectVo.setCode(CalDataFromEnum.SALES_PLAN.getCode());
                planSelectVo.setValue(CalDataFromEnum.SALES_PLAN.getDesc());
                commonSelectVoList.add(planSelectVo);
                CommonSelectVo commonSelectVo = new CommonSelectVo();
                commonSelectVo.setCode(CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode());
                commonSelectVo.setValue(CalDataFromEnum.ACTUAL_SALES_AMOUNT.getDesc());
                commonSelectVoList.add(commonSelectVo);
            }
            return commonSelectVoList;
        }
        List salesGoalList = SalesGoalAmountTypeEnum.concertEnumToList();
        Map salesGoalMap = SalesGoalAmountTypeEnum.concertEnumToMap();
        List salesPlanList = SalesPlanAmountTypeEnum.concertEnumToList();
        Map salesPlanMap = SalesPlanAmountTypeEnum.concertEnumToMap();
        List actualSalesList = ActualSalesAmountTypeEnum.concertEnumToList();
        Map actualSalesMap = ActualSalesAmountTypeEnum.concertEnumToMap();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)code) || CalDataFromEnum.SALES_GOAL.getCode().equals(code)) {
            salesGoalList.forEach(salesGoal -> {
                CommonSelectVo commonSelectVo = new CommonSelectVo();
                commonSelectVo.setCode(salesGoal);
                commonSelectVo.setValue((String)salesGoalMap.get(salesGoal));
                commonSelectVoList.add(commonSelectVo);
            });
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)code) || CalDataFromEnum.SALES_PLAN.getCode().equals(code)) {
            salesPlanList.forEach(salesPlan -> {
                CommonSelectVo commonSelectVo = new CommonSelectVo();
                commonSelectVo.setCode(salesPlan);
                commonSelectVo.setValue((String)salesPlanMap.get(salesPlan));
                commonSelectVoList.add(commonSelectVo);
            });
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)code) || CalDataFromEnum.ACTUAL_SALES_AMOUNT.getCode().equals(code)) {
            actualSalesList.forEach(actualSales -> {
                CommonSelectVo commonSelectVo = new CommonSelectVo();
                commonSelectVo.setCode(actualSales);
                commonSelectVo.setValue((String)actualSalesMap.get(actualSales));
                commonSelectVoList.add(commonSelectVo);
            });
        }
        return commonSelectVoList;
    }
}

