package com.biz.crm.tpm.business.budget.cal.config.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigProductRatioVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.util.Date;
import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 15:27
 */
@ApiModel(value = "BudgetCalConfigDto", description = "TPM-预算计算配置")
@Getter
@Setter
public class BudgetCalConfigDto extends TenantFlagOpDto {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(value = "预算计算编码")
    private String budgetCalCode;

    /**
     * 预算计算名称
     */
    @ApiModelProperty(value = "预算计算名称")
    private String budgetCalName;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 预算类型[数据字典:tpm_budget_type]
     */
    @ApiModelProperty(value = "预算类型[数据字典:tpm_budget_type]")
    private String budgetTypeCode;

    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    private String feeBelongCode;

    /**
     * 销售组织范围[数据字典:tpm_org_area]
     */
    @ApiModelProperty(name = "销售组织范围[数据字典:tpm_org_area]", notes = "销售组织范围[数据字典:tpm_org_area]")
    private String orgAreaCode;

    /**
     * 生效起始时间
     */
    @ApiModelProperty("生效起始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date effectBeginTime;

    /**
     * 生效结束时间
     */
    @ApiModelProperty("生效结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date effectEndTime;

    /**
     * 包含销售组织集合
     */
    @ApiModelProperty(value = "包含销售组织集合", notes = "包含销售组织集合")
    private List<BudgetCalConfigSalesOrgDto> salesOrgList;

    /**
     * 客户非包含集合
     */
    @ApiModelProperty(value = "客户非包含集合")
    private List<BudgetCalConfigAreaDto> customerList;

    /**
     * 门店非包含集合
     */
    @ApiModelProperty(value = "门店非包含集合")
    private List<BudgetCalConfigAreaDto> terminalList;

    /**
     * 产品非包含集合
     */
    @ApiModelProperty(value = "产品非包含集合")
    private List<BudgetCalConfigAreaDto> productList;

    /**
     * 预算项目包含集合
     */
    @ApiModelProperty(value = "预算项目包含集合")
    private List<BudgetCalConfigAreaDto> budgetItemList;

    /**
     * 数据配置集合
     */
    @ApiModelProperty(value = "数据配置集合")
    private List<BudgetCalConfigDataDto> dataList;

    /**
     * 预算计算配置产品计费比例
     */
    @ApiModelProperty(value = "预算计算配置产品计费比例")
    private List<BudgetCalConfigProductRatioDto> productRatioVos;

    /**
     * 产品计费比例缓存key
     */
    @ApiModelProperty(value = "产品计费比例缓存key")
    private String cacheKey;

    /**
     * 管控类型
     */
    @ApiModelProperty(value = "管控类型[数据字典:tpm_budget_control_type]", notes = "")
    private String controlType;

    /**
     * 分组[数据字典:tpm_group_code]
     */
    @ApiModelProperty(value = "分组[数据字典:tpm_group_code]", notes = "")
    private String groupCode;
}
