package com.biz.crm.tpm.business.budget.cal.config.sdk.eunm;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author huojia
 * @date 2022年11月03日 9:55
 */
@Getter
public enum ActualSalesAmountTypeEnum {

    ORDER_RULE_AMT_IN_REBATE("order_rule_amt_in_rebate", "折前金额(订单含返点常规金额)'"),

    WAREHS_OUT_DISCOUNT_AMT("warehs_out_discount_amt", "折后实际销额"),

    DISCOUNT_BEHIND_SALE_AMOUNT("discount_behind_sale_amount", "主体-折后销售额（不含奶卡）"),

    DISCOUNT_BEHIND_TAX_SALE_AMOUNT("discount_behind_tax_sale_amount", "主体-折后销售额（含奶卡）"),

    SALE_QUANTITY("sale_quantity", "主体-销量"),

    DELIVERY_MULTIPLY_PRICE("delivery_multiply_price","主体-出库件数*单品到岸价")

    ;

    private String code;
    private String desc;

    ActualSalesAmountTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (ActualSalesAmountTypeEnum t : ActualSalesAmountTypeEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }

    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (ActualSalesAmountTypeEnum t : ActualSalesAmountTypeEnum.values()) {
            map.put(t.getCode(), t.getDesc());
        }
        return map;
    }

    public static ActualSalesAmountTypeEnum getByCode(String val) {
        ActualSalesAmountTypeEnum[] values = ActualSalesAmountTypeEnum.values();
        Optional<ActualSalesAmountTypeEnum> first = Arrays.stream(values).filter(e -> e.getCode().equals(val)).findFirst();
        return !first.isPresent() ? null : first.get();
    }
}
