package com.biz.crm.tpm.business.budget.cal.config.sdk.eunm;

import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年11月03日 18:02
 */
@Getter
public enum BudgetTypeEnum {
    YEAR_BUDGET("year_budget", "年度预算"),
    MONTH_BUDGET("month_budget", "月度预算"),
    ;

    private String code;
    private String desc;

    BudgetTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (BudgetTypeEnum t : BudgetTypeEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }

    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (BudgetTypeEnum t : BudgetTypeEnum.values()) {
            map.put(t.getCode(), t.getDesc());
        }
        return map;
    }
}
