package com.biz.crm.tpm.business.budget.cal.config.sdk.eunm;

import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年11月03日 9:55
 */
@Getter
public enum CalDataFromEnum {
    SALES_GOAL("sales_goal", "销售任务"),
    SALES_PLAN("sales_plan", "销售计划"),
    ACTUAL_SALES_AMOUNT("actual_sales_amount", "实际销量"),
    ;

    private String code;
    private String desc;

    CalDataFromEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (CalDataFromEnum t : CalDataFromEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }

    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (CalDataFromEnum t : CalDataFromEnum.values()) {
            map.put(t.getCode(), t.getDesc());
        }
        return map;
    }
}
