package com.biz.crm.tpm.business.budget.cal.config.sdk.eunm;

import lombok.Getter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年11月03日 9:55
 */
@Getter
public enum SalesGoalAmountTypeEnum {


    /*PURCHASE_SALES_AMOUNT("purchase_sales_amount", "进货折前销售额"),
    PURCHASE_DISCOUNT_SALES_AMOUNT("purchase_discount_sales_amount", "进货折后销售额"),*/

    DELIVERY_SALES_AMOUNT("delivery_sales_amount", "折前销售额"),
    DELIVERY_DISCOUNT_SALES_AMOUNT("delivery_discount_sales_amount", "折后销售额"),
    DELIVERY_MULTIPLY_PRICE("delivery_multiply_price","出库件数*单品到岸价");

    private String code;
    private String desc;

    SalesGoalAmountTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (SalesGoalAmountTypeEnum t : SalesGoalAmountTypeEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }

    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (SalesGoalAmountTypeEnum t : SalesGoalAmountTypeEnum.values()) {
            map.put(t.getCode(), t.getDesc());
        }
        return map;
    }

}
