package com.biz.crm.tpm.business.budget.cal.config.sdk.eunm;

import lombok.Getter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * @author huojia
 * @date 2022年11月03日 9:55
 */
@Getter
public enum SalesPlanAmountTypeEnum {

    PLAN_AMOUNT("plan_amount", "折前计划金额"),

    DISCOUNT_PLAN_AMOUNT("discount_plan_amount", "折后计划金额"),

    RESTORE_AMOUNT("restore_amount", "折前回复金额"),

    DISCOUNT_RESTORE_AMOUNT("discount_restore_amount", "折后回复金额"),

    DELIVERY_MULTIPLY_PRICE("delivery_multiply_price","出库件数*单品到岸价"),

    PLAN_QUANTITY("plan_quantity","计划数量"),

    RESTORE_QUANTITY("restore_quantity","回复数量"),

    ;

    private String code;
    private String desc;

    SalesPlanAmountTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static List<String> concertEnumToList() {
        List<String> list = new ArrayList<>();
        for (SalesPlanAmountTypeEnum t : SalesPlanAmountTypeEnum.values()) {
            list.add(t.getCode());
        }
        return list;
    }

    public static Map<String, String> concertEnumToMap() {
        Map<String, String> map = new HashMap<>();
        for (SalesPlanAmountTypeEnum t : SalesPlanAmountTypeEnum.values()) {
            map.put(t.getCode(), t.getDesc());
        }
        return map;
    }

    public static SalesPlanAmountTypeEnum getByCode(String val) {
        SalesPlanAmountTypeEnum[] values = SalesPlanAmountTypeEnum.values();
        Optional<SalesPlanAmountTypeEnum> first = Arrays.stream(values).filter(e -> e.getCode().equals(val)).findFirst();
        return !first.isPresent() ? null : first.get();
    }
}
