package com.biz.crm.tpm.business.budget.cal.config.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.budget.cal.config.sdk.dto.BudgetCalConfigDto;
import com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 15:24
 */
public interface BudgetCalConfigService {

    /**
     * 分页查询列表
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo>
     * @author huojia
     * @date 2022/11/2 22:49
     **/
    Page<BudgetCalConfigVo> findByConditions(Pageable pageable, BudgetCalConfigDto dto);

    /**
     * 根据id查询预算计算配置
     *
     * @param id
     * @return com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo
     * @author huojia
     * @date 2022/11/2 23:00
     **/
    BudgetCalConfigVo findById(String id);

    /**
     * 新增
     *
     * @param dto
     * @return com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo
     * @author huojia
     * @date 2022/11/2 23:00
     **/
    BudgetCalConfigVo create(BudgetCalConfigDto dto);

    /**
     * 编辑
     *
     * @param dto
     * @return com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo
     * @author huojia
     * @date 2022/11/2 23:00
     **/
    BudgetCalConfigVo update(BudgetCalConfigDto dto);

    /**
     * 批量删除
     *
     * @param ids
     * @author huojia
     * @date 2022/11/2 23:04
     **/
    void delete(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @author huojia
     * @date 2022/11/2 23:04
     **/
    void enable(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @author huojia
     * @date 2022/11/2 23:04
     **/
    void disable(List<String> ids);

    /**
     * 条件查询列表
     *
     * @param budgetCalConfigDto
     * @return java.util.List<com.biz.crm.tpm.business.budget.cal.config.sdk.vo.BudgetCalConfigVo>
     * @author huojia
     * @date 2022/11/3 17:16
     **/
    List<BudgetCalConfigVo> listByConditions(BudgetCalConfigDto budgetCalConfigDto);

    /**
     * 下拉数据
     *
     * @param type
     * @param code
     * @return java.util.List<com.biz.crm.mn.common.base.vo.CommonSelectVo>
     * @author huojia
     * @date 2023/1/10 22:21
     **/
    List<CommonSelectVo> listSelect(String type, String code);
}
