package com.biz.crm.tpm.business.budget.cal.config.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.util.List;

/**
 * @author huojia
 * @date 2022年11月02日 22:43
 */
@ApiModel(value = "BudgetCalConfigAreaDto", description = "TPM-预算计算配置范围")
@Getter
@Setter
public class BudgetCalConfigAreaVo extends TenantFlagOpVo {

    /**
     * 预算计算编码
     */
    @ApiModelProperty(value = "预算计算编码")
    private String budgetCalCode;

    /**
     * 范围类型编码
     */
    @ApiModelProperty(value = "范围类型编码")
    private String areaTypeCode;

    /**
     * 数据编码
     */
    @ApiModelProperty(value = "数据编码")
    private String dataCode;

    /**
     * 数据名称
     */
    @ApiModelProperty(value = "数据名称")
    private String dataName;

    /**
     * 客户类型[数据字典:mdm_customer_type]
     */
    @ApiModelProperty(value = "客户类型[数据字典:mdm_customer_type]")
    private String customerTypeCode;

    /**
     * 客户级别
     */
    @ApiModelProperty(value = "客户级别")
    private String customerLevelCode;

    /**
     * 客户渠道编码
     */
    @ApiModelProperty(value = "客户渠道编码")
    private String customerChannelCode;

    /**
     * 客户渠道名称
     */
    @ApiModelProperty(value = "客户渠道名称")
    private String customerChannelName;

    /**
     * 一级渠道编码
     */
    @ApiModelProperty(value = "一级渠道编码")
    private String firstChannelCode;

    /**
     * 一级渠道名称
     */
    @ApiModelProperty(value = "一级渠道名称")
    private String firstChannelName;

    /**
     * 二级渠道编码
     */
    @ApiModelProperty(value = "二级渠道编码")
    private String secondChannelCode;

    /**
     * 二级渠道名称
     */
    @ApiModelProperty(value = "二级渠道名称")
    private String secondChannelName;

    /**
     * 上级客户/分销商编码
     */
    @ApiModelProperty(value = "上级客户/分销商编码")
    private String parentCustomerCode;

    /**
     * 上级客户/分销商名称
     */
    @ApiModelProperty(value = "上级客户/分销商名称")
    private String parentCustomerName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称")
    private String productCategoryName;

    /**
     * 品项编码
     */
    @ApiModelProperty(value = "品项编码")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty(value = "品项名称")
    private String productItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    private String budgetItemLevelCode;

    /**
     * 上级预算项目编码
     */
    @ApiModelProperty(value = "上级预算项目编码", notes = "")
    private String parentBudgetItemCode;

    /**
     * 上级预算项目名称
     */
    @ApiModelProperty(value = "上级预算项目名称", notes = "")
    private String parentBudgetItemName;

    /**
     * 费用属性[数据字典:tpm_budget_fee_attr]
     */
    @ApiModelProperty(value = "费用属性[数据字典:tpm_budget_fee_attr]", notes = "")
    private String feeAttrCode;

    /**
     * 指定剔除年月
     */
    @ApiModelProperty(value = "指定剔除年月yyyy-MM")
    private String filYearMonth;

    /**
     * 预算计算配置预算范围产品
     */
    @ApiModelProperty(value = "预算计算配置预算范围产品")
    private List<BudgetCalConfigScopeProductVo> scopeProducts;
}
